/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.workspace;

import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.portal.application.StandaloneAppRequestContext;
import org.exoplatform.portal.resource.Skin;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.webui.application.UIStandaloneAppContainer;
import org.exoplatform.portal.webui.workspace.UIStandaloneApplicationLifecycle;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.exoplatform.web.url.MimeType;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.url.ComponentURL;
import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.ResourceScope;
import org.gatein.portal.controller.resource.script.FetchMap;
import org.gatein.portal.controller.resource.script.Module;
import org.gatein.portal.controller.resource.script.ScriptResource;
import org.json.JSONObject;

@ComponentConfig(lifecycle=UIStandaloneApplicationLifecycle.class, template="system:/groovy/portal/webui/workspace/UIStandaloneApplication.gtmpl")
public class UIStandaloneApplication
extends UIApplication {
    public static final int NORMAL_MODE = 0;
    private int modeState = 0;
    private Locale locale_ = Locale.ENGLISH;
    private String skin_ = null;
    private Orientation orientation_ = Orientation.LT;
    private boolean isSessionOpen = false;
    public static final UIComponent EMPTY_COMPONENT = new UIComponent(){

        public String getId() {
            return "{portal:componentId}";
        }
    };

    public UIStandaloneApplication() throws Exception {
        this.addChild(UIStandaloneAppContainer.class, null, null);
    }

    public void renderChildren() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        super.renderChildren(context);
    }

    public void processDecode(WebuiRequestContext context) throws Exception {
        UIStandaloneAppContainer staContaner;
        String storageId = ((StandaloneAppRequestContext)context).getStorageId();
        if (!storageId.equals((staContaner = (UIStandaloneAppContainer)this.getChild(UIStandaloneAppContainer.class)).getCurrStorageId())) {
            staContaner.setCurrStorageId(storageId);
        }
        super.processDecode(context);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer w = context.getWriter();
        if (!context.useAjax()) {
            super.processRender(context);
        } else {
            Set list = context.getUIComponentToUpdateByAjax();
            w.write("<div class=\"PortalResponse\">");
            w.write("<div class=\"PortalResponseData\">");
            if (list != null) {
                for (UIComponent uicomponent : list) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("AJAX call: Need to refresh the UI component " + uicomponent.getName()));
                    }
                    this.renderBlockToUpdate(uicomponent, context, w);
                }
            }
            w.write("</div>");
            w.write("<div class=\"LoadingScripts\">");
            this.writeLoadingScripts(context);
            w.write("</div>");
            w.write("<div class=\"PortalResponseScript\">");
            JavascriptManager jsManager = context.getJavascriptManager();
            w.write(jsManager.getJavaScripts());
            w.write("</div>");
            w.write("</div>");
        }
    }

    private void writeLoadingScripts(WebuiRequestContext context) throws Exception {
        Writer w = context.getWriter();
        Map<String, Boolean> scriptURLs = this.getScripts();
        w.write("<div class=\"ImmediateScripts\">");
        w.write(StringUtils.join(scriptURLs.keySet(), (String)","));
        w.write("</div>");
    }

    public Map<String, Boolean> getScripts() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        JavascriptManager jsMan = context.getJavascriptManager();
        jsMan.loadScriptResource(ResourceScope.SHARED, "bootstrap");
        FetchMap requiredResources = jsMan.getScriptResources();
        log.debug("Resource ids to resolve: {}", new Object[]{requiredResources});
        JavascriptConfigService service = (JavascriptConfigService)this.getApplicationComponent(JavascriptConfigService.class);
        LinkedHashMap<String, Boolean> ret = new LinkedHashMap<String, Boolean>();
        Map tmp = service.resolveIds((Map)requiredResources);
        for (ScriptResource rs : tmp.keySet()) {
            ResourceId id = rs.getId();
            boolean isRemote = !rs.isEmpty() && rs.getModules().get(0) instanceof Module.Remote;
            ret.put(id.toString(), isRemote);
        }
        for (String url : jsMan.getExtendedScriptURLs()) {
            ret.put(url, true);
        }
        log.debug((Object)("Resolved resources for page: " + ret));
        return ret;
    }

    public JSONObject getJSConfig() throws Exception {
        JavascriptConfigService service = (JavascriptConfigService)this.getApplicationComponent(JavascriptConfigService.class);
        StandaloneAppRequestContext context = (StandaloneAppRequestContext)WebuiRequestContext.getCurrentInstance();
        return service.getJSConfig(context.getControllerContext(), context.getLocale());
    }

    public Collection<Skin> getPortalSkins() {
        SkinService skinService = (SkinService)this.getApplicationComponent(SkinService.class);
        ArrayList<Skin> skins = new ArrayList<Skin>(skinService.getPortalSkins(this.skin_));
        return skins;
    }

    public Set<Skin> getPortletSkins() {
        HashSet<Skin> skins = new HashSet<Skin>();
        return skins;
    }

    public boolean isSessionOpen() {
        return this.isSessionOpen;
    }

    public void setSessionOpen(boolean isSessionOpen) {
        this.isSessionOpen = isSessionOpen;
    }

    public String getSkin() {
        return this.skin_;
    }

    public Orientation getOrientation() {
        return this.orientation_;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation_ = orientation;
    }

    public Locale getLocale() {
        return this.locale_;
    }

    public void setLocale(Locale locale) {
        this.locale_ = locale;
    }

    public void setModeState(int mode) {
        this.modeState = mode;
    }

    public int getModeState() {
        return this.modeState;
    }

    public String getPortalURLTemplate() throws UnsupportedEncodingException {
        StandaloneAppRequestContext context = (StandaloneAppRequestContext)WebuiRequestContext.getCurrentInstance();
        ComponentURL urlTemplate = (ComponentURL)context.createURL(ComponentURL.TYPE);
        urlTemplate.setMimeType(MimeType.PLAIN);
        urlTemplate.setPath(context.getNodePath());
        urlTemplate.setResource(EMPTY_COMPONENT);
        urlTemplate.setAction("{portal:action}");
        return URLDecoder.decode(urlTemplate.toString(), "UTF-8");
    }
}

