/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth2.validators;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.apache.shindig.social.core.oauth2.OAuth2Client;
import org.apache.shindig.social.core.oauth2.OAuth2DataService;
import org.apache.shindig.social.core.oauth2.OAuth2Exception;
import org.apache.shindig.social.core.oauth2.OAuth2NormalizedRequest;
import org.apache.shindig.social.core.oauth2.OAuth2NormalizedResponse;
import org.apache.shindig.social.core.oauth2.OAuth2Types;
import org.apache.shindig.social.core.oauth2.validators.AuthCodeGrantValidator;
import org.apache.shindig.social.core.oauth2.validators.ClientCredentialsGrantValidator;
import org.apache.shindig.social.core.oauth2.validators.OAuth2GrantValidator;
import org.apache.shindig.social.core.oauth2.validators.OAuth2RequestValidator;

public class AccessTokenRequestValidator
implements OAuth2RequestValidator {
    private OAuth2DataService store = null;
    private List<OAuth2GrantValidator> grantValidators = new ArrayList<OAuth2GrantValidator>();

    @Inject
    public AccessTokenRequestValidator(OAuth2DataService store) {
        this.grantValidators.add(new AuthCodeGrantValidator(store));
        this.grantValidators.add(new ClientCredentialsGrantValidator(store));
        this.store = store;
    }

    @Override
    public void validateRequest(OAuth2NormalizedRequest req) throws OAuth2Exception {
        if (req.getGrantType() != null) {
            for (OAuth2GrantValidator validator : this.grantValidators) {
                if (!validator.getGrantType().equals(req.getGrantType())) continue;
                validator.validateRequest(req);
                return;
            }
            OAuth2NormalizedResponse response = new OAuth2NormalizedResponse();
            response.setStatus(400);
            response.setError(OAuth2Types.ErrorType.UNSUPPORTED_GRANT_TYPE.toString());
            response.setErrorDescription("Unsupported grant type");
            response.setBodyReturned(true);
            throw new OAuth2Exception(response);
        }
        if (req.getResponseType() == null || !req.getResponseType().equals("token")) {
            OAuth2NormalizedResponse resp = new OAuth2NormalizedResponse();
            resp.setError(OAuth2Types.ErrorType.UNSUPPORTED_RESPONSE_TYPE.toString());
            resp.setErrorDescription("Unsupported response type");
            resp.setStatus(403);
            throw new OAuth2Exception(resp);
        }
        OAuth2Client client = this.store.getClient(req.getClientId());
        if (client == null || client.getFlow() != OAuth2Client.Flow.IMPLICIT) {
            OAuth2NormalizedResponse resp = new OAuth2NormalizedResponse();
            resp.setError(OAuth2Types.ErrorType.INVALID_CLIENT.toString());
            resp.setErrorDescription(req.getClientId() + " is not a registered implicit client");
            resp.setBodyReturned(true);
            resp.setStatus(403);
            throw new OAuth2Exception(resp);
        }
        if (req.getRedirectURI() == null && client.getRedirectURI() == null) {
            OAuth2NormalizedResponse resp = new OAuth2NormalizedResponse();
            resp.setError(OAuth2Types.ErrorType.INVALID_REQUEST.toString());
            resp.setErrorDescription("No redirect_uri registered or received in request");
            resp.setBodyReturned(true);
            resp.setStatus(403);
            throw new OAuth2Exception(resp);
        }
        if (req.getRedirectURI() != null && !req.getRedirectURI().equals(client.getRedirectURI())) {
            OAuth2NormalizedResponse resp = new OAuth2NormalizedResponse();
            resp.setError(OAuth2Types.ErrorType.INVALID_REQUEST.toString());
            resp.setErrorDescription("Redirect URI does not match the one registered for this client");
            resp.setBodyReturned(true);
            resp.setStatus(403);
            throw new OAuth2Exception(resp);
        }
    }
}

