/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.protocol.BaseRequestItem;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.apache.shindig.protocol.multipart.FormDataItem;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.json.JSONObject;

public class SocialRequestItem
extends BaseRequestItem {
    private static final String USER_ID = "userId";
    private static final String GROUP_ID = "groupId";

    public SocialRequestItem(Map<String, String[]> parameters, SecurityToken token, BeanConverter converter, BeanJsonConverter jsonConverter) {
        super(parameters, token, converter, jsonConverter);
    }

    public SocialRequestItem(JSONObject parameters, Map<String, FormDataItem> formItems, SecurityToken token, BeanConverter converter, BeanJsonConverter jsonConverter) {
        super(parameters, formItems, token, converter, jsonConverter);
    }

    public Set<UserId> getUsers() {
        List ids = this.getListParameter(USER_ID);
        if (ids.isEmpty()) {
            Preconditions.checkArgument((this.token.getViewerId() != null ? 1 : 0) != 0, (Object)"No userId provided and viewer not available");
            return ImmutableSet.of((Object)UserId.fromJson("@me"));
        }
        ImmutableSet.Builder userIds = ImmutableSet.builder();
        for (String id : ids) {
            userIds.add((Object)UserId.fromJson(id));
        }
        return userIds.build();
    }

    public GroupId getGroup() {
        return GroupId.fromJson(this.getParameter(GROUP_ID, "@self"));
    }

    public String getSortBy() {
        String sortBy = super.getSortBy();
        return sortBy == null ? "topFriends" : sortBy;
    }
}

