/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.opt;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.Keyword;
import com.google.caja.parser.js.BooleanLiteral;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Reference;

public final class Fact {
    final Type type;
    final Expression value;
    private static final FilePosition UNK = FilePosition.UNKNOWN;
    static Fact TRUTHY = new Fact(Type.LIKE, new BooleanLiteral(UNK, true));
    static Fact FALSEY = new Fact(Type.LIKE, new BooleanLiteral(UNK, false));
    static Fact TRUE = Fact.is((Literal)Fact.TRUTHY.value);
    static Fact FALSE = Fact.is((Literal)Fact.FALSEY.value);
    static Fact UNDEFINED = new Fact(Type.IS, Operation.create(UNK, Operator.VOID, new IntegerLiteral(UNK, 0L)));
    static Fact GLOBAL = new Fact(Type.LIKE, new Reference(new Identifier(UNK, Keyword.THIS.toString())));

    private Fact(Type type, Expression value) {
        this.type = type;
        this.value = value;
    }

    boolean isLessSpecificThan(Fact that) {
        if (this.type == Type.LIKE && that.type == Type.IS) {
            return true;
        }
        return this != that && that == GLOBAL;
    }

    public static Fact is(Literal value) {
        return new Fact(Type.IS, value);
    }

    boolean isTruthy() {
        if (this == GLOBAL) {
            return true;
        }
        if (this == UNDEFINED) {
            return false;
        }
        return ((Literal)this.value).getValueInBooleanContext();
    }

    boolean isFalsey() {
        return !this.isTruthy();
    }

    boolean isTrue() {
        return this.type == Type.IS && this.value instanceof BooleanLiteral && ((BooleanLiteral)this.value).getValue() != false;
    }

    boolean isFalse() {
        return this.type == Type.IS && this.value instanceof BooleanLiteral && ((BooleanLiteral)this.value).getValue() == false;
    }

    boolean isGlobal() {
        return this == GLOBAL;
    }

    boolean isUndefined() {
        return this == UNDEFINED;
    }

    boolean isSubstitutable(boolean isFuzzy) {
        return this.type == Type.IS || isFuzzy && this != GLOBAL;
    }

    public String toString() {
        return "[Fact " + (Object)((Object)this.type) + " " + this.value + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        IS,
        LIKE;

    }
}

