/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.opt;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.js.AbstractStatement;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CatchStmt;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.DirectivePrologue;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.ForEachLoop;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.MultiDeclaration;
import com.google.caja.parser.js.Noop;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.Statement;
import com.google.caja.util.Lists;
import com.google.caja.util.Pair;
import com.google.caja.util.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarCollector {
    public static void optimize(Block program) {
        VarCollector.optimize(program, Collections.<Identifier>emptySet());
    }

    private static void optimize(Block body, Set<Identifier> alreadyDeclared) {
        Set<Identifier> locals = VarCollector.newIdentSet();
        List<FunctionConstructor> inners = Lists.newArrayList();
        VarCollector.unvar(body, locals, inners);
        Set<Identifier> needed = VarCollector.newIdentSet(locals);
        needed.removeAll(alreadyDeclared);
        if (!needed.isEmpty()) {
            List<Operation> topAssignments = VarCollector.extractAssignments(body, VarCollector.newIdentSet(locals));
            List<Declaration> decls = Lists.newArrayList();
            for (Operation topAssign : topAssignments) {
                Identifier id = ((Reference)topAssign.children().get(0)).getIdentifier();
                decls.add(new Declaration(topAssign.getFilePosition(), id, topAssign.children().get(1)));
                needed.remove(id);
            }
            for (Identifier name : needed) {
                decls.add(new Declaration(name.getFilePosition(), name, null));
            }
            Statement decl = decls.size() == 1 ? (Statement)decls.get(0) : new MultiDeclaration(FilePosition.startOf(body.getFilePosition()), decls);
            Statement declFollower = null;
            List<? extends Statement> bodyChildren = body.children();
            if (!bodyChildren.isEmpty()) {
                declFollower = bodyChildren.get(0);
            }
            if (declFollower instanceof DirectivePrologue) {
                declFollower = bodyChildren.size() == 1 ? null : bodyChildren.get(1);
            }
            body.insertBefore(decl, declFollower);
        }
        for (FunctionConstructor inner : inners) {
            Set<Identifier> formals = VarCollector.newIdentSet();
            for (FormalParam p : inner.getParams()) {
                formals.add(p.getIdentifier());
            }
            VarCollector.optimize(inner.getBody(), formals);
        }
    }

    private static void unvar(Block node, final Set<Identifier> removedIdents, final List<FunctionConstructor> inners) {
        final List<Pair> changes = Lists.newArrayList();
        node.acceptPreOrder(new Visitor(){

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean visit(AncestorChain<?> chain) {
                Object node = chain.node;
                if (node instanceof Declaration && !(node instanceof FunctionDeclaration)) {
                    if (chain.parent.node instanceof CatchStmt) {
                        return true;
                    }
                    Declaration decl = (Declaration)node;
                    Identifier id = decl.getIdentifier();
                    removedIdents.add(id);
                    Expression expression = decl.getInitializer();
                    AbstractStatement replacement = expression != null ? new ExpressionStmt(VarCollector.toAssignment(decl)) : (chain.parent.node instanceof ForEachLoop ? new ExpressionStmt(new Reference(id)) : new Noop(decl.getFilePosition()));
                    changes.add(Pair.pair(chain.cast(Statement.class), replacement));
                    return true;
                }
                if (node instanceof MultiDeclaration) {
                    AbstractStatement replacement;
                    List<Expression> replacements = Lists.newArrayList();
                    for (Declaration declaration : ((MultiDeclaration)node).children()) {
                        removedIdents.add(declaration.getIdentifier());
                        if (declaration.getInitializer() == null) continue;
                        this.visit(chain.child(declaration).child(declaration.getInitializer()));
                        Expression assign = VarCollector.toAssignment(declaration);
                        replacements.add(assign);
                    }
                    if (replacements.isEmpty()) {
                        replacement = new Noop(node.getFilePosition());
                    } else if (replacements.size() == 1) {
                        Expression expression = (Expression)replacements.get(0);
                        replacement = new ExpressionStmt(expression.getFilePosition(), expression);
                    } else if (chain.parent.node instanceof Block) {
                        List<ExpressionStmt> list = Lists.newArrayList();
                        for (Expression e : replacements) {
                            list.add(new ExpressionStmt(e));
                        }
                        replacement = new Block(node.getFilePosition(), list);
                    } else {
                        void var5_12;
                        Object var5_11 = null;
                        for (Expression e : replacements) {
                            Expression expression = var5_12 == null ? e : Operation.createInfix(Operator.COMMA, (Expression)var5_12, e);
                        }
                        replacement = new ExpressionStmt(node.getFilePosition(), (Expression)var5_12);
                    }
                    changes.add(Pair.pair(chain.cast(Statement.class), replacement));
                    return false;
                }
                if (node instanceof FunctionConstructor) {
                    inners.add((FunctionConstructor)node);
                    return false;
                }
                return true;
            }
        }, null);
        for (Pair change : changes) {
            ((MutableParseTreeNode)((AncestorChain)change.a).parent.cast(MutableParseTreeNode.class).node).replaceChild((ParseTreeNode)change.b, (ParseTreeNode)((AncestorChain)change.a).node);
        }
    }

    private static Expression toAssignment(Declaration decl) {
        return Operation.create(decl.getFilePosition(), Operator.ASSIGN, new Reference(decl.getIdentifier()), decl.getInitializer());
    }

    private static List<Operation> extractAssignments(Block body, Set<Identifier> unassigned) {
        List<Operation> extracted = Lists.newArrayList();
        while (!body.children().isEmpty()) {
            Reference r;
            Operation op;
            Expression lhs;
            Expression e;
            Statement first = body.children().get(0);
            if (first instanceof Noop) {
                body.removeChild(first);
                continue;
            }
            if (first instanceof Block) {
                extracted.addAll(VarCollector.extractAssignments((Block)first, unassigned));
                if (!first.children().isEmpty()) break;
                body.removeChild(first);
            }
            if (!(first instanceof ExpressionStmt) || !Operation.is((ParseTreeNode)(e = ((ExpressionStmt)first).getExpression()), Operator.ASSIGN) || !((lhs = (op = (Operation)e).children().get(0)) instanceof Reference) || !unassigned.contains((r = (Reference)lhs).getIdentifier())) break;
            unassigned.remove(r.getIdentifier());
            extracted.add(op);
            body.removeChild(first);
        }
        return extracted;
    }

    private static Set<Identifier> newIdentSet() {
        return Sets.newTreeSet(new Comparator<Identifier>(){

            @Override
            public int compare(Identifier a, Identifier b) {
                return a.getName().compareTo(b.getName());
            }
        });
    }

    private static Set<Identifier> newIdentSet(Set<Identifier> c) {
        Set<Identifier> idents = VarCollector.newIdentSet();
        idents.addAll(c);
        return idents;
    }
}

