/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lang.css;

import com.google.caja.util.Bag;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Partitions {
    Partitions() {
    }

    static <T> Partition<T> partition(Iterable<? extends Iterable<T>> sets, Class<T> type, Comparator<?> cmp) {
        int i;
        int el;
        int j;
        int nSets = 0;
        Map<T, Integer> elToIndex = Maps.newHashMap();
        Bag<T> bag = Bag.newHashBag();
        for (Iterable<T> set : sets) {
            for (T el2 : set) {
                bag.incr(el2);
            }
            ++nSets;
        }
        Set uniq = bag.nonZeroCounts();
        T[] universe = Partitions.allocateReferenceTypeArray(type, uniq.size());
        int i2 = 0;
        for (T el2 : uniq) {
            universe[i2++] = el2;
        }
        Partitions.tryToSort(universe, cmp);
        for (i2 = 0; i2 < universe.length; ++i2) {
            elToIndex.put(universe[i2], i2);
        }
        ISlice nonZeroCols = new ISlice();
        nonZeroCols.count = universe.length;
        nonZeroCols.els = new int[nonZeroCols.count];
        for (int i3 = 0; i3 < nonZeroCols.count; ++i3) {
            nonZeroCols.els[i3] = i3;
        }
        ISlice[] matrix = new ISlice[nSets];
        i2 = 0;
        BitSet rowBits = new BitSet(universe.length);
        for (Iterable<T> set : sets) {
            rowBits.clear();
            for (T el3 : set) {
                int index = (Integer)elToIndex.get(el3);
                if (rowBits.get(index)) continue;
                rowBits.set(index);
            }
            ISlice row = new ISlice();
            row.count = rowBits.cardinality();
            row.els = new int[row.count];
            int b = -1;
            j = 0;
            while ((b = rowBits.nextSetBit(b + 1)) >= 0) {
                row.els[j++] = b;
            }
            Arrays.sort(row.els);
            matrix[i2++] = row;
        }
        ISlice nonZeroRows = new ISlice();
        nonZeroRows.els = new int[nSets];
        for (int i4 = 0; i4 < matrix.length; ++i4) {
            if (matrix[i4].count == 0) continue;
            nonZeroRows.els[nonZeroRows.count++] = i4;
        }
        List<ISlice> partition = Lists.newArrayList();
        ISlice[] unionIndices = new ISlice[nSets];
        for (int i5 = 0; i5 < nSets; ++i5) {
            unionIndices[i5] = new ISlice();
            unionIndices[i5].els = new int[universe.length];
        }
        while (nonZeroRows.count != 0) {
            ISlice r;
            ISlice bestPartitionElement = null;
            for (int i6 = 0; i6 < nonZeroCols.count; ++i6) {
                int j2;
                el = nonZeroCols.els[i6];
                ISlice candidate = null;
                for (j2 = 0; j2 < nonZeroRows.count; ++j2) {
                    r = matrix[nonZeroRows.els[j2]];
                    if (!r.contains(el)) continue;
                    if (candidate == null) {
                        candidate = r.clone();
                        continue;
                    }
                    candidate.preserve(r);
                }
                assert (candidate != null);
                for (j2 = 0; j2 < nonZeroRows.count; ++j2) {
                    r = matrix[nonZeroRows.els[j2]];
                    if (r.contains(el)) continue;
                    candidate.subtract(r);
                }
                if (bestPartitionElement != null && bestPartitionElement.count >= candidate.count) continue;
                bestPartitionElement = candidate;
            }
            assert (bestPartitionElement != null);
            int partitionIndex = partition.size();
            partition.add(bestPartitionElement);
            nonZeroCols.subtract(bestPartitionElement);
            int k = 0;
            for (j = 0; j < nonZeroRows.count; ++j) {
                int rowIndex = nonZeroRows.els[j];
                r = matrix[rowIndex];
                boolean changed = r.subtract(bestPartitionElement);
                if (changed) {
                    unionIndices[rowIndex].els[unionIndices[rowIndex].count++] = partitionIndex;
                }
                if (r.count != 0) {
                    nonZeroRows.els[k++] = rowIndex;
                    continue;
                }
                assert (changed);
            }
            nonZeroRows.count = k;
            if (bestPartitionElement.count != 1) continue;
            break;
        }
        int[] elementToPartition = new int[universe.length];
        for (i = 0; i < nonZeroCols.count; ++i) {
            el = nonZeroCols.els[i];
            ISlice singleton = new ISlice();
            singleton.count = 1;
            singleton.els = new int[]{el};
            elementToPartition[el] = partition.size();
            partition.add(singleton);
        }
        nonZeroCols.count = 0;
        for (int j3 = 0; j3 < nonZeroRows.count; ++j3) {
            int rowIndex = nonZeroRows.els[j3];
            ISlice r = matrix[rowIndex];
            ISlice union = unionIndices[rowIndex];
            for (int i7 = 0; i7 < r.count; ++i7) {
                int el4 = r.els[i7];
                union.els[union.count++] = elementToPartition[el4];
            }
            r.count = 0;
        }
        nonZeroRows.count = 0;
        Partition result = new Partition();
        result.universe = universe;
        result.unions = new int[unionIndices.length][];
        for (i = 0; i < unionIndices.length; ++i) {
            result.unions[i] = unionIndices[i].toArray();
        }
        result.partition = new int[partition.size()][];
        for (i = 0; i < result.partition.length; ++i) {
            result.partition[i] = ((ISlice)partition.get(i)).toArray();
        }
        return result;
    }

    private static <T> T[] allocateReferenceTypeArray(Class<T> type, int n) {
        if (type.isPrimitive()) {
            throw new AssertionError((Object)type.getName());
        }
        return (Object[])Array.newInstance(type, n);
    }

    private static <T> void tryToSort(T[] arr, Comparator<?> cmp) {
        if (cmp == null) {
            final Class<?> tClazz = arr.getClass().getComponentType();
            if (!Comparable.class.isAssignableFrom(tClazz)) {
                return;
            }
            cmp = new Comparator<Comparable<?>>(){

                @Override
                public int compare(Comparable<?> a, Comparable<?> b) {
                    Object at = tClazz.cast(a);
                    Object bt = tClazz.cast(b);
                    if (at == null) {
                        return bt == null ? 0 : -1;
                    }
                    if (bt == null) {
                        return 1;
                    }
                    return ((Comparable)at).compareTo(bt);
                }
            };
        }
        Arrays.sort(arr, cmp);
    }

    private static class ISlice {
        int[] els;
        int count;

        private ISlice() {
        }

        boolean subtract(ISlice r) {
            int i = 0;
            int j = 0;
            int k = 0;
            while (i < this.count && j < r.count) {
                int a = this.els[i];
                int b = r.els[j];
                if (a < b) {
                    this.els[k++] = this.els[i++];
                    continue;
                }
                if (a == b) {
                    ++i;
                    ++j;
                    continue;
                }
                ++j;
            }
            if (i != this.count) {
                int n = this.count - i;
                System.arraycopy(this.els, i, this.els, k, n);
                k += n;
            }
            if (this.count != k) {
                this.count = k;
                return true;
            }
            return false;
        }

        void preserve(ISlice r) {
            int i = 0;
            int j = 0;
            int k = 0;
            while (i < this.count && j < r.count) {
                int a = this.els[i];
                int b = r.els[j];
                if (a < b) {
                    ++i;
                    continue;
                }
                if (a == b) {
                    this.els[k++] = a;
                    ++i;
                    ++j;
                    continue;
                }
                ++j;
            }
            this.count = k;
        }

        boolean contains(int el) {
            return Arrays.binarySearch(this.els, 0, this.count, el) >= 0;
        }

        public ISlice clone() {
            ISlice clone = new ISlice();
            clone.els = this.toArray();
            clone.count = this.count;
            return clone;
        }

        int[] toArray() {
            return Arrays.copyOfRange(this.els, 0, this.count);
        }

        public String toString() {
            return Arrays.toString(this.toArray());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Partition<T> {
        int[][] unions;
        T[] universe;
        int[][] partition;

        Partition() {
        }
    }
}

