/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.BufferBackedSequence;
import com.google.caja.lexer.DecodingCharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlEntities;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.SourceBreaks;
import com.google.caja.lexer.UriDecoder;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;

public abstract class CharProducer
implements CharSequence,
Cloneable {
    private int offset;
    private final int limit;
    private final char[] buf;

    CharProducer(char[] buf, int limit) {
        this.buf = buf;
        this.limit = limit;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final char[] getBuffer() {
        return this.buf;
    }

    public final void consume(int n) {
        this.consumeTo(this.offset + n);
    }

    public final void consumeTo(int end) {
        assert (this.offset <= end && end <= this.limit);
        this.offset = end;
    }

    public final String toString(int start, int end) {
        return String.valueOf(this.buf, start, end - start);
    }

    public final String toString() {
        return this.toString(this.offset, this.limit);
    }

    public final int getLength() {
        return this.limit - this.offset;
    }

    public final boolean isEmpty() {
        return this.offset == this.limit;
    }

    public abstract int getCharInFile(int var1);

    public abstract SourceBreaks getSourceBreaks(int var1);

    public FilePosition getCurrentPosition() {
        return this.getSourceBreaks(this.offset).toFilePosition(this.getCharInFile(this.offset));
    }

    public FilePosition filePositionForOffsets(int start, int end) {
        return this.getSourceBreaks(start).toFilePosition(this.getCharInFile(start), this.getCharInFile(end));
    }

    public CharSequence subSequence(int start, int end) {
        if (end > this.limit || start < 0 || end < start) {
            throw new IndexOutOfBoundsException();
        }
        return new BufferBackedSequence(this.buf, start + this.offset, end + this.offset);
    }

    public final int length() {
        return this.limit - this.offset;
    }

    public char charAt(int i) {
        if (i < 0 || (i += this.offset) >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return this.buf[i];
    }

    public abstract CharProducer clone();

    private static class ChainCharProducer
    extends CharProducer {
        private final int[] ends;
        private final CharProducer[] srcs;

        private ChainCharProducer(char[] concatenation, int[] ends, CharProducer ... srcs) {
            super(concatenation, concatenation.length);
            this.ends = ends;
            this.srcs = srcs;
        }

        private ChainCharProducer(ChainCharProducer orig) {
            super(orig.getBuffer(), orig.getLimit());
            this.ends = orig.ends;
            this.srcs = orig.srcs;
            this.consume(orig.getOffset());
        }

        static CharProducer make(CharProducer ... srcs) {
            int[] ends = new int[srcs.length];
            for (int i = 0; i < srcs.length; ++i) {
                CharProducer s = srcs[i];
                int length = s.getLimit() - s.getOffset();
                ends[i] = i != 0 ? ends[i - 1] + length : length;
            }
            char[] concatenation = new char[ends[ends.length - 1]];
            int pos = 0;
            for (CharProducer s : srcs) {
                int len = s.getLimit() - s.getOffset();
                System.arraycopy(s.getBuffer(), s.getOffset(), concatenation, pos, len);
                pos += len;
            }
            return new ChainCharProducer(concatenation, ends, srcs);
        }

        public int getCharInFile(int offset) {
            int i = Arrays.binarySearch(this.ends, offset);
            if (i < 0) {
                i ^= 0xFFFFFFFF;
            }
            int prev = i == 0 ? 0 : this.ends[i - 1];
            return this.srcs[i].getCharInFile(offset - prev);
        }

        public SourceBreaks getSourceBreaks(int offset) {
            int i = Arrays.binarySearch(this.ends, offset);
            if (i < 0) {
                i ^= 0xFFFFFFFF;
            }
            int prev = i == 0 ? 0 : this.ends[i - 1];
            return this.srcs[i].getSourceBreaks(offset - prev);
        }

        public CharProducer clone() {
            return new ChainCharProducer(this);
        }
    }

    public static final class Factory {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CharProducer create(Reader r, FilePosition pos) throws IOException {
            int limit = 0;
            char[] buf = new char[4096];
            try {
                int n = 0;
                while ((n = r.read(buf, limit, buf.length - limit)) > 0) {
                    if ((limit += n) != buf.length) continue;
                    char[] newBuf = new char[buf.length * 2];
                    System.arraycopy(buf, 0, newBuf, 0, limit);
                    buf = newBuf;
                }
            }
            finally {
                r.close();
            }
            return new CharProducerImpl(buf, limit, pos);
        }

        public static CharProducer fromString(CharSequence s, InputSource src) {
            return Factory.fromString(s, FilePosition.startOfFile(src));
        }

        public static CharProducer fromString(CharSequence s, FilePosition pos) {
            char[] buf;
            if (s instanceof String) {
                buf = ((String)s).toCharArray();
            } else {
                buf = new char[s.length()];
                for (int i = 0; i < buf.length; ++i) {
                    buf[i] = s.charAt(i);
                }
            }
            return new CharProducerImpl(buf, buf.length, pos);
        }

        public static CharProducer create(Reader r, InputSource src) throws IOException {
            return Factory.create(r, FilePosition.startOfFile(src));
        }

        public static CharProducer create(StringReader r, InputSource src) {
            try {
                return Factory.create((Reader)r, FilePosition.startOfFile(src));
            }
            catch (IOException ex) {
                throw new SomethingWidgyHappenedError("Error reading chars from String");
            }
        }

        public static CharProducer create(StringReader r, FilePosition pos) {
            try {
                return Factory.create((Reader)r, pos);
            }
            catch (IOException ex) {
                throw new SomethingWidgyHappenedError("Error reading chars from String");
            }
        }

        public static CharProducer fromJsString(CharProducer p) {
            return DecodingCharProducer.make(new DecodingCharProducer.Decoder(){

                void decode(char[] chars, int offset, int limit) {
                    int codePoint;
                    int ch = chars[offset];
                    if (92 != ch || offset + 1 >= limit) {
                        this.codePoint = ch;
                        this.end = offset + 1;
                        return;
                    }
                    int ch2 = chars[offset + 1];
                    int end = offset + 2;
                    switch (ch2) {
                        case 98: {
                            codePoint = 8;
                            break;
                        }
                        case 114: {
                            codePoint = 13;
                            break;
                        }
                        case 110: {
                            codePoint = 10;
                            break;
                        }
                        case 102: {
                            codePoint = 12;
                            break;
                        }
                        case 116: {
                            codePoint = 9;
                            break;
                        }
                        case 118: {
                            codePoint = 11;
                            break;
                        }
                        case 117: 
                        case 120: {
                            int nHex = ch2 == 117 ? 4 : 2;
                            int hexStart = offset + 2;
                            int hexEnd = offset + 2 + nHex;
                            if (hexEnd <= limit && this.decodeHex(chars, hexStart, hexEnd, hexEnd)) {
                                return;
                            }
                            codePoint = ch2;
                            break;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            this.decodeOctal(chars, offset + 1, offset + (ch2 <= 51 ? 4 : 3));
                            return;
                        }
                        default: {
                            codePoint = ch2;
                        }
                    }
                    this.codePoint = codePoint;
                    this.end = end;
                }
            }, p);
        }

        public static CharProducer fromHtmlAttribute(CharProducer p) {
            return DecodingCharProducer.make(new DecodingCharProducer.Decoder(){

                void decode(char[] chars, int offset, int limit) {
                    long packedEndAndCodepoint = HtmlEntities.decodeEntityAt(chars, offset, limit);
                    this.codePoint = (int)(packedEndAndCodepoint & 0xFFFFFFL);
                    this.end = (int)(packedEndAndCodepoint >>> 32);
                }
            }, p);
        }

        public static CharProducer fromUri(CharProducer p) {
            return DecodingCharProducer.make(new UriDecoder(), p);
        }

        public static CharProducer chain(CharProducer ... srcs) {
            if (srcs.length == 0) {
                return new CharProducerImpl(new char[0], 0, FilePosition.UNKNOWN);
            }
            if (srcs.length == 1) {
                return srcs[0];
            }
            return ChainCharProducer.make(srcs);
        }

        private Factory() {
        }

        private static final class CharProducerImpl
        extends CharProducer {
            private final SourceBreaks breaks;
            private final int charInFile;

            CharProducerImpl(char[] buf, int limit, FilePosition pos) {
                super(buf, limit);
                this.charInFile = pos.startCharInFile();
                this.breaks = new SourceBreaks(pos.source(), pos.startLineNo() - 1);
                this.breaks.lineStartsAt(this.charInFile - pos.startCharInLine() + 1);
                for (int i = 0; i < limit; ++i) {
                    char ch = buf[i];
                    if (ch != '\n' && (ch != '\r' || i + 1 >= limit || buf[i + 1] == '\n')) continue;
                    this.breaks.lineStartsAt(this.charInFile + i + 1);
                }
            }

            private CharProducerImpl(CharProducerImpl orig) {
                super(orig.getBuffer(), orig.getLimit());
                this.breaks = orig.breaks;
                this.charInFile = orig.charInFile;
                this.consume(orig.getOffset());
            }

            public int getCharInFile(int offset) {
                return this.charInFile + offset;
            }

            public SourceBreaks getSourceBreaks(int offset) {
                return this.breaks;
            }

            public CharProducer clone() {
                return new CharProducerImpl(this);
            }
        }
    }
}

