/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.FilePosition;
import java.net.URI;
import javax.annotation.Nullable;

public final class ExternalReference {
    private final URI uri;
    private final URI base;
    private final URI relUri;
    private final FilePosition pos;

    public ExternalReference(URI uri, FilePosition pos) {
        this(uri, uri, uri, pos);
    }

    public ExternalReference(URI uri, URI base, URI relUri, FilePosition pos) {
        this.uri = uri;
        this.base = base;
        this.relUri = relUri;
        this.pos = pos;
    }

    public URI getUri() {
        return this.uri;
    }

    public URI getBase() {
        return this.base;
    }

    public URI getUnresolvedUri() {
        return this.relUri;
    }

    public FilePosition getReferencePosition() {
        return this.pos;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof ExternalReference)) {
            return false;
        }
        ExternalReference that = (ExternalReference)o;
        return this.uri.equals(that.uri);
    }

    public String toString() {
        return this.uri.toString() + " @ " + this.pos;
    }
}

