/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.CssLexer;
import com.google.caja.lexer.CssTokenType;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.reporting.DevNullMessageQueue;
import com.google.caja.util.ContentType;
import javax.annotation.Nullable;

public final class GuessContentType {
    public static ContentType guess(@Nullable String mimeType, @Nullable String path, @Nullable CharSequence code) {
        int dot;
        ContentType contentType = null;
        if (mimeType != null) {
            contentType = ContentType.fromMimeType(mimeType);
        }
        if (contentType == null && path != null && (dot = path.lastIndexOf(46)) >= 0) {
            String ext = path.substring(dot + 1);
            for (ContentType candidate : ContentType.values()) {
                if (!ext.equals(candidate.ext)) continue;
                contentType = candidate;
                break;
            }
        }
        if (contentType == null && code != null) {
            char ch = '\u0000';
            int n = code.length();
            for (int i = 0; i < n && Character.isWhitespace(ch = (char)code.charAt(i)); ++i) {
            }
            switch (ch) {
                case '<': {
                    contentType = ContentType.HTML;
                    break;
                }
                case '#': 
                case '.': 
                case '@': {
                    contentType = ContentType.CSS;
                }
            }
        }
        if (contentType == null && code != null) {
            CharProducer cp = CharProducer.Factory.fromString(code, FilePosition.UNKNOWN);
            boolean sawColon = false;
            try {
                CssLexer cssLexer = new CssLexer(cp, DevNullMessageQueue.singleton(), false);
                contentType = ContentType.CSS;
                while (cssLexer.hasNext()) {
                    Token<CssTokenType> t = cssLexer.next();
                    if ("if".equals(t.text) || "while".equals(t.text) || "for".equals(t.text) || "return".equals(t.text) || "?".equals(t.text)) {
                        contentType = ContentType.JS;
                        break;
                    }
                    if (sawColon || !":".equals(t.text)) continue;
                    sawColon = true;
                }
                if (!sawColon) {
                    contentType = ContentType.JS;
                }
            }
            catch (ParseException ex) {
                contentType = ContentType.JS;
            }
        }
        return contentType;
    }
}

