/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.AbstractTokenStream;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlInputSplitter;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.util.Strings;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlLexer
extends AbstractTokenStream<HtmlTokenType> {
    private final HtmlInputSplitter splitter;
    private State state = State.OUTSIDE_TAG;
    private final LinkedList<Token<HtmlTokenType>> lookahead = new LinkedList();
    private static final Set<String> VALUELESS_ATTRIB_NAMES = new HashSet<String>(Arrays.asList("checked", "compact", "declare", "defer", "disabled", "ismap", "multiple", "nohref", "noresize", "noshade", "nowrap", "readonly", "selected"));

    public HtmlLexer(CharProducer p) {
        this.splitter = new HtmlInputSplitter(p);
    }

    public boolean getTreatedAsXml() {
        return this.splitter.getTreatedAsXml();
    }

    public void setTreatedAsXml(boolean asXml) {
        this.splitter.setTreatedAsXml(asXml);
    }

    @Override
    protected Token<HtmlTokenType> produce() throws ParseException {
        Token<HtmlTokenType> token = this.readToken();
        if (token == null) {
            return null;
        }
        block0 : switch ((HtmlTokenType)token.type) {
            case TAGBEGIN: {
                this.state = State.IN_TAG;
                break;
            }
            case TAGEND: {
                if (this.state == State.SAW_EQ && HtmlTokenType.TAGEND == token.type && !this.getTreatedAsXml()) {
                    this.pushbackToken(token);
                    this.state = State.IN_TAG;
                    return Token.instance("", HtmlTokenType.ATTRVALUE, FilePosition.startOf(token.pos));
                }
                this.state = State.OUTSIDE_TAG;
                break;
            }
            case IGNORABLE: {
                return this.produce();
            }
            default: {
                switch (this.state) {
                    case OUTSIDE_TAG: {
                        if (HtmlTokenType.TEXT != token.type && HtmlTokenType.UNESCAPED != token.type) break block0;
                        token = this.collapseSubsequent(token);
                        break block0;
                    }
                    case IN_TAG: {
                        if (HtmlTokenType.TEXT != token.type || "=".equals(token.text)) break block0;
                        token = HtmlInputSplitter.reclassify(token, HtmlTokenType.ATTRNAME);
                        this.state = State.SAW_NAME;
                        break block0;
                    }
                    case SAW_NAME: {
                        if (HtmlTokenType.TEXT == token.type) {
                            if ("=".equals(token.text)) {
                                this.state = State.SAW_EQ;
                                return this.produce();
                            }
                            token = HtmlInputSplitter.reclassify(token, HtmlTokenType.ATTRNAME);
                            break block0;
                        }
                        this.state = State.IN_TAG;
                        break block0;
                    }
                    case SAW_EQ: {
                        if (HtmlTokenType.TEXT != token.type && HtmlTokenType.QSTRING != token.type) break block0;
                        if (HtmlTokenType.TEXT == token.type) {
                            token = this.collapseAttributeName(token);
                        }
                        token = HtmlInputSplitter.reclassify(token, HtmlTokenType.ATTRVALUE);
                        this.state = State.IN_TAG;
                    }
                }
            }
        }
        return token;
    }

    private Token<HtmlTokenType> collapseSubsequent(Token<HtmlTokenType> token) throws ParseException {
        Token<HtmlTokenType> next;
        Token<HtmlTokenType> collapsed = token;
        while ((next = this.peekToken(0)) != null && next.type == token.type) {
            collapsed = HtmlLexer.join(collapsed, next);
            this.readToken();
        }
        return collapsed;
    }

    private Token<HtmlTokenType> collapseAttributeName(Token<HtmlTokenType> token) throws ParseException {
        Token<HtmlTokenType> t;
        Token<HtmlTokenType> t2;
        if (this.getTreatedAsXml()) {
            return token;
        }
        int nToMerge = 0;
        while ((t2 = this.peekToken(nToMerge)) != null) {
            if (t2.type == HtmlTokenType.IGNORABLE) {
                Token<HtmlTokenType> text = this.peekToken(nToMerge + 1);
                if (text == null || text.type != HtmlTokenType.TEXT || HtmlLexer.isValuelessAttribute(text.text)) break;
                Token<HtmlTokenType> eq = this.peekToken(nToMerge + 2);
                if (eq != null && eq.type == HtmlTokenType.IGNORABLE) {
                    eq = this.peekToken(nToMerge + 3);
                }
                if (eq == null || "=".equals(eq.text)) {
                    break;
                }
            } else if (t2.type != HtmlTokenType.TEXT) break;
            ++nToMerge;
        }
        if (nToMerge == 0) {
            return token;
        }
        StringBuilder sb = new StringBuilder(token.text);
        do {
            t = this.readToken();
            sb.append(t.text);
        } while (--nToMerge > 0);
        return Token.instance(sb.toString(), HtmlTokenType.TEXT, FilePosition.span(token.pos, t.pos));
    }

    private static Token<HtmlTokenType> join(Token<HtmlTokenType> a, Token<HtmlTokenType> b) {
        return Token.instance(a.text + b.text, a.type, FilePosition.span(a.pos, b.pos));
    }

    private Token<HtmlTokenType> readToken() throws ParseException {
        if (!this.lookahead.isEmpty()) {
            return this.lookahead.remove();
        }
        if (this.splitter.hasNext()) {
            return this.splitter.next();
        }
        return null;
    }

    private Token<HtmlTokenType> peekToken(int i) throws ParseException {
        while (this.lookahead.size() <= i && this.splitter.hasNext()) {
            this.lookahead.add(this.splitter.next());
        }
        return this.lookahead.size() > i ? this.lookahead.get(i) : null;
    }

    private void pushbackToken(Token<HtmlTokenType> token) {
        this.lookahead.addFirst(token);
    }

    private static boolean isValuelessAttribute(String attribName) {
        boolean valueless = VALUELESS_ATTRIB_NAMES.contains(Strings.lower(attribName));
        return valueless;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        OUTSIDE_TAG,
        IN_TAG,
        SAW_NAME,
        SAW_EQ;

    }
}

