/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer.escaping;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.util.Join;
import com.google.caja.util.Lists;
import com.google.caja.util.Strings;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UriUtil {
    private static final Pattern RFC_3986 = Pattern.compile("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$", 32);

    public static String normalizeUri(String uri) throws URISyntaxException {
        uri = UriUtil.normalizeSpecialCharacters(uri);
        Matcher m = RFC_3986.matcher(uri);
        m.matches();
        String scheme = m.group(1);
        String authority = m.group(2);
        String path = m.group(3);
        String query = m.group(4);
        String fragment = m.group(5);
        StringBuilder sb = new StringBuilder(uri.length());
        if (scheme != null) {
            UriUtil.normalizeScheme(scheme, sb);
            sb.append(':');
        }
        if (authority != null) {
            if ("".equals(authority) && !Strings.eqIgnoreCase("file", scheme)) {
                throw new URISyntaxException(uri, "Blank authority");
            }
            sb.append("//");
            UriUtil.normalizeAuthority(authority, sb);
        } else if (scheme != null && !Strings.eqIgnoreCase("file", scheme) && !UriUtil.isOpaque(scheme)) {
            throw new URISyntaxException(uri, "Missing authority");
        }
        if (path.length() != 0 || sb.length() != 0) {
            UriUtil.normalizePath(path, sb.length() != 0 && !UriUtil.isOpaque(scheme), sb);
        }
        if (query != null) {
            sb.append('?');
            UriUtil.normalizeQuery(query, sb);
        }
        if (fragment != null) {
            sb.append('#');
            UriUtil.normalizeFragment(fragment, sb);
        }
        return sb.toString();
    }

    private static String normalizeSpecialCharacters(String uri) {
        int n;
        StringBuilder sb = null;
        int pos = 0;
        int i = n = uri.length();
        block9: while (--i >= 0) {
            char subst;
            switch (uri.charAt(i)) {
                case '\ufe13': 
                case '\ufe55': 
                case '\uff1a': {
                    subst = ':';
                    break;
                }
                case '\uff0f': {
                    subst = '/';
                    break;
                }
                case '\ufe16': 
                case '\ufe56': 
                case '\uff1f': {
                    subst = '?';
                    break;
                }
                case '\ufe5f': 
                case '\uff03': {
                    subst = '#';
                    break;
                }
                case '\u207c': 
                case '\u208c': 
                case '\ufe66': 
                case '\uff1d': {
                    subst = '=';
                    break;
                }
                case '\ufe60': 
                case '\uff06': {
                    subst = '&';
                    break;
                }
                case '\u2024': 
                case '\ufe52': 
                case '\uff0e': {
                    subst = '.';
                    break;
                }
                default: {
                    continue block9;
                }
            }
            if (sb == null) {
                sb = new StringBuilder(n);
            }
            sb.append(uri, pos, i).append(subst);
            pos = i + 1;
        }
        return sb == null ? uri : sb.toString();
    }

    public static URI resolve(URI base, String relative) throws URISyntaxException {
        String path;
        URI abs = base.resolve(UriUtil.normalizeUri(relative));
        if (!abs.isOpaque() && (path = abs.getPath()) != null && (path.startsWith("/../") || path.equals("/.."))) {
            return null;
        }
        return abs;
    }

    public static String encode(String part) {
        int n = part.length();
        for (int i = 0; i < n; ++i) {
            char ch = part.charAt(i);
            if (ch < '\u0080' && Escaping.URI_ESCAPES.getEscape(ch) == null) continue;
            StringBuilder out = new StringBuilder(n + (n >> 2));
            Escaping.escapeUri((CharSequence)part, i, out);
            return out.toString();
        }
        return part;
    }

    private static void normalizeScheme(String scheme, StringBuilder out) {
        int pos = 0;
        int n = scheme.length();
        for (int i = 0; i < n; ++i) {
            char ch = scheme.charAt(i);
            if (ch == '%') {
                if (!UriUtil.isInvalidEsc(scheme, i)) continue;
                out.append(scheme, pos, i).append("%25");
                pos = i + 1;
                continue;
            }
            if ('A' <= ch && ch <= 'Z') {
                out.append(scheme, pos, i).append((char)(ch | 0x20));
                pos = i + 1;
                continue;
            }
            if ('a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9' || ch == '+' || ch == '-' || ch == '.') continue;
            out.append(scheme, pos, i);
            pos = i + 1;
            UriUtil.pctEncode(ch, out);
        }
        out.append(scheme, pos, n);
    }

    private static boolean isOpaque(String scheme) {
        return Strings.eqIgnoreCase("mailto", scheme) || Strings.eqIgnoreCase("javascript", scheme) || Strings.eqIgnoreCase("content", scheme) || Strings.eqIgnoreCase("data", scheme) || Strings.eqIgnoreCase("clsid", scheme);
    }

    private static void normalizeAuthority(String authority, StringBuilder out) throws URISyntaxException {
        int pos = 0;
        int n = authority.length();
        for (int i = 0; i < n; ++i) {
            char ch = authority.charAt(i);
            if (ch == '%') {
                if (!UriUtil.isInvalidEsc(authority, i)) continue;
                out.append(authority, pos, i).append("%25");
                pos = i + 1;
                continue;
            }
            if (ch == ':') {
                for (int j = i + 1; j < n; ++j) {
                    ch = authority.charAt(j);
                    if ('0' <= ch && ch <= '9') continue;
                    throw new URISyntaxException(authority, "Bad port " + authority.substring(i + 1), j);
                }
                break;
            }
            if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || ch == '-' || ch == '+' || ch == '.') continue;
            out.append(authority, pos, i);
            pos = i + 1;
            UriUtil.pctEncode(ch, out);
        }
        out.append(authority, pos, n);
    }

    private static void normalizePath(String path, boolean requireAbsPath, StringBuilder out) {
        String normPath = UriUtil.normalizeEscapesInPath(path);
        boolean isAbs = requireAbsPath;
        if (normPath.startsWith("/")) {
            normPath = normPath.substring(1);
            isAbs = true;
        }
        List<String> pathParts = Lists.newArrayList(normPath.split("/"));
        int i = 0;
        while (i < pathParts.size()) {
            String dottedPart = pathParts.get(i).replace("%2e", ".").replace("%2E", ".");
            if (".".equals(dottedPart)) {
                pathParts.remove(i);
                continue;
            }
            if ("..".equals(dottedPart)) {
                if (i > 0 && !"..".equals(pathParts.get(i - 1))) {
                    pathParts.subList(--i, i + 2).clear();
                    continue;
                }
                if (isAbs) {
                    pathParts.remove(i);
                    continue;
                }
                pathParts.set(i, "..");
                ++i;
                continue;
            }
            ++i;
        }
        if (isAbs) {
            out.append('/');
        }
        Join.join(out, (CharSequence)"/", pathParts);
    }

    private static String normalizeEscapesInPath(String path) {
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int n = path.length();
        for (int i = 0; i < n; ++i) {
            char ch = path.charAt(i);
            if (ch == '%') {
                if (!UriUtil.isInvalidEsc(path, i)) continue;
                sb.append(path, pos, i).append("%25");
                pos = i + 1;
                continue;
            }
            if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || ch == ':' || ch == '-' || ch == '+' || ch == '.' || ch == '/' || ch == ',' || ch == '$') continue;
            sb.append(path, pos, i);
            pos = i + 1;
            UriUtil.pctEncode(ch, sb);
        }
        sb.append(path, pos, n);
        return sb.toString();
    }

    private static void normalizeQuery(String query, StringBuilder out) {
        int pos = 0;
        int n = query.length();
        for (int i = 0; i < n; ++i) {
            char ch = query.charAt(i);
            if (ch == '%') {
                if (!UriUtil.isInvalidEsc(query, i)) continue;
                out.append(query, pos, i).append("%25");
                pos = i + 1;
                continue;
            }
            if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || ch == '-' || ch == '+' || ch == '.' || ch == '=' || ch == '&' || ch == ',') continue;
            out.append(query, pos, i);
            pos = i + 1;
            UriUtil.pctEncode(ch, out);
        }
        out.append(query, pos, n);
    }

    private static void normalizeFragment(String fragment, StringBuilder out) {
        int pos = 0;
        int n = fragment.length();
        for (int i = 0; i < n; ++i) {
            char ch = fragment.charAt(i);
            if (ch == '%') {
                if (!UriUtil.isInvalidEsc(fragment, i)) continue;
                out.append(fragment, pos, i).append("%25");
                pos = i + 1;
                continue;
            }
            if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || ch == '-' || ch == '+' || ch == '.') continue;
            out.append(fragment, pos, i);
            pos = i + 1;
            UriUtil.pctEncode(ch, out);
        }
        out.append(fragment, pos, n);
    }

    private static boolean isInvalidEsc(String uriPart, int pctIdx) {
        return pctIdx + 2 >= uriPart.length() || !UriUtil.isHexDigit(uriPart.charAt(pctIdx + 1)) || !UriUtil.isHexDigit(uriPart.charAt(pctIdx + 2));
    }

    private static boolean isHexDigit(char ch) {
        return '0' <= ch && ch <= '9' || 'a' <= ch && ch <= 'f' || 'A' <= ch && ch <= 'F';
    }

    private static void pctEncode(char ch, StringBuilder out) {
        try {
            Escaping.pctEncode(ch, (Appendable)out);
        }
        catch (IOException ex) {
            throw new SomethingWidgyHappenedError("StringBuilders shouldn't throw IOException", (Throwable)ex);
        }
    }

    private UriUtil() {
    }
}

