/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.NoChildren;
import com.google.caja.render.Concatenator;
import com.google.caja.reporting.MarkupRenderMode;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Callback;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Dom
extends AbstractParseTreeNode {
    private static final long serialVersionUID = -5111504015682453850L;
    private final DocumentFragment fragment;

    public Dom(DocumentFragment fragment) {
        super(Nodes.getFilePositionFor(fragment), NoChildren.class);
        this.fragment = fragment;
    }

    public static Dom transplant(Node node) {
        if (node.getNodeType() == 9) {
            node = ((Document)node).getDocumentElement();
        } else if (node.getNodeType() == 11) {
            return new Dom((DocumentFragment)node);
        }
        DocumentFragment f = node.getOwnerDocument().createDocumentFragment();
        f.appendChild(node);
        Nodes.setFilePositionFor(f, Nodes.getFilePositionFor(node));
        return new Dom(f);
    }

    @Override
    public boolean makeImmutable() {
        return false;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public DocumentFragment getValue() {
        return this.fragment;
    }

    @Override
    public TokenConsumer makeRenderer(Appendable out, Callback<IOException> handler) {
        return new Concatenator(out, handler);
    }

    @Override
    public void render(RenderContext r) {
        Nodes.render((Node)this.fragment, r);
    }

    @Override
    public void formatSelf(MessageContext context, int depth, Appendable out) throws IOException {
        out.append(this.getClass().getSimpleName()).append(" : ");
        String html = Nodes.render((Node)this.fragment, MarkupRenderMode.XML).replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r");
        out.append(html);
    }

    @Override
    public Dom clone() {
        return new Dom((DocumentFragment)this.fragment.cloneNode(true));
    }
}

