/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.Token;
import com.google.caja.parser.html.AttrStub;
import com.google.caja.parser.html.AttributeNameFixup;
import com.google.caja.parser.html.CajaTreeBuilder;
import com.google.caja.parser.html.DomParserMessageType;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.html.OpenElementStack;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Strings;
import com.google.common.collect.MapMaker;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.validator.htmlparser.common.DoctypeExpectation;
import nu.validator.htmlparser.common.TokenHandler;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.impl.AttributeName;
import nu.validator.htmlparser.impl.ElementName;
import nu.validator.htmlparser.impl.HtmlAttributes;
import nu.validator.htmlparser.impl.Tokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Html5ElementStack
implements OpenElementStack {
    public static final Logger logger = Logger.getLogger(Html5ElementStack.class.getName());
    private final CajaTreeBuilder builder;
    private final char[] charBuf = new char[1024];
    private final MessageQueue mq;
    private final Document doc;
    private final boolean needsDebugData;
    private final Map<String, ElementName> elNames = Maps.newHashMap();
    private boolean isFragment;
    private boolean needsNamespaceFixup;
    private boolean topLevelHtmlFromInput = false;
    private boolean processingFirstTag = true;
    private static final Map<HtmlAttributes, List<Attr>> HTML_ASSOCIATED_ATTRS = new MapMaker().weakKeys().makeMap();
    private static final String FIXABLE_ENTITY_NAMES = "(?:AACUTE|ACIRC|ACUTE|AELIG|AGRAVE|AMP|ARING|ATILDE|AUML|Aacute|Acirc|Agrave|Aring|Atilde|Auml|BRVBAR|CCEDIL|CEDIL|CENT|COPY|CURREN|Ccedil|DEG|DIVIDE|EACUTE|ECIRC|EGRAVE|ETH|EUML|Eacute|Ecirc|Egrave|Euml|FRAC12|FRAC14|FRAC34|GT|IACUTE|ICIRC|IEXCL|IGRAVE|IQUEST|IUML|Iacute|Icirc|Igrave|Iuml|LAQUO|LT|MACR|MICRO|MIDDOT|NBSP|NOT|NTILDE|Ntilde|OACUTE|OCIRC|OGRAVE|ORDF|ORDM|OSLASH|OTILDE|OUML|Oacute|Ocirc|Ograve|Oslash|Otilde|Ouml|PARA|PLUSMN|POUND|QUOT|RAQUO|REG|SECT|SHY|SUP1|SUP2|SUP3|SZLIG|THORN|TIMES|UACUTE|UCIRC|UGRAVE|UML|UUML|Uacute|Ucirc|Ugrave|Uuml|YACUTE|YEN|YUML|Yacute|aacute|acirc|acute|aelig|agrave|amp|aring|atilde|auml|brvbar|ccedil|cedil|cent|copy|curren|deg|divide|eacute|ecirc|egrave|eth|euml|frac12|frac14|frac34|gt|iacute|icirc|iexcl|igrave|iquest|iuml|laquo|lt|macr|micro|middot|nbsp|not|ntilde|oacute|ocirc|ograve|ordf|ordm|oslash|otilde|ouml|para|plusmn|pound|quot|raquo|reg|sect|shy|sup1|sup2|sup3|szlig|thorn|times|uacute|ucirc|ugrave|uml|uuml|yacute|yen|yuml)";
    private static final Pattern BROKEN_ENTITY = Pattern.compile("&(?:(?:AACUTE|ACIRC|ACUTE|AELIG|AGRAVE|AMP|ARING|ATILDE|AUML|Aacute|Acirc|Agrave|Aring|Atilde|Auml|BRVBAR|CCEDIL|CEDIL|CENT|COPY|CURREN|Ccedil|DEG|DIVIDE|EACUTE|ECIRC|EGRAVE|ETH|EUML|Eacute|Ecirc|Egrave|Euml|FRAC12|FRAC14|FRAC34|GT|IACUTE|ICIRC|IEXCL|IGRAVE|IQUEST|IUML|Iacute|Icirc|Igrave|Iuml|LAQUO|LT|MACR|MICRO|MIDDOT|NBSP|NOT|NTILDE|Ntilde|OACUTE|OCIRC|OGRAVE|ORDF|ORDM|OSLASH|OTILDE|OUML|Oacute|Ocirc|Ograve|Oslash|Otilde|Ouml|PARA|PLUSMN|POUND|QUOT|RAQUO|REG|SECT|SHY|SUP1|SUP2|SUP3|SZLIG|THORN|TIMES|UACUTE|UCIRC|UGRAVE|UML|UUML|Uacute|Ucirc|Ugrave|Uuml|YACUTE|YEN|YUML|Yacute|aacute|acirc|acute|aelig|agrave|amp|aring|atilde|auml|brvbar|ccedil|cedil|cent|copy|curren|deg|divide|eacute|ecirc|egrave|eth|euml|frac12|frac14|frac34|gt|iacute|icirc|iexcl|igrave|iquest|iuml|laquo|lt|macr|micro|middot|nbsp|not|ntilde|oacute|ocirc|ograve|ordf|ordm|oslash|otilde|ouml|para|plusmn|pound|quot|raquo|reg|sect|shy|sup1|sup2|sup3|szlig|thorn|times|uacute|ucirc|ugrave|uml|uuml|yacute|yen|yuml)(?![=;0-9A-Za-z])|#(?:[0-9]{1,7}(?![=;0-9])|[Xx][0-9A-Fa-f]{1,6}(?![=;0-9A-Za-z])))");
    static final Attr XMLNS_ATTR_MARKER = null;

    Html5ElementStack(Document doc, boolean needsDebugData, MessageQueue queue) {
        this.doc = doc;
        this.needsDebugData = needsDebugData;
        this.mq = queue;
        this.builder = new CajaTreeBuilder(doc, needsDebugData, this.mq);
    }

    @Override
    public final Document getDocument() {
        return this.doc;
    }

    @Override
    public boolean needsNamespaceFixup() {
        return this.needsNamespaceFixup;
    }

    @Override
    public void open(boolean isFragment) {
        this.isFragment = isFragment;
        if (isFragment) {
            this.builder.setFragmentContext(null);
        }
        this.builder.setDoctypeExpectation(DoctypeExpectation.NO_DOCTYPE_ERRORS);
        try {
            this.builder.startTokenization(new Tokenizer((TokenHandler)this.builder));
        }
        catch (SAXException ex) {
            throw new SomethingWidgyHappenedError(ex);
        }
        this.builder.setErrorHandler(new ErrorHandler(){
            private FilePosition lastPos;
            private String lastMessage;

            public void error(SAXParseException ex) {
                this.report(MessageLevel.LINT, ex);
            }

            public void fatalError(SAXParseException ex) {
                this.report(MessageLevel.FATAL_ERROR, ex);
            }

            public void warning(SAXParseException ex) {
                this.report(MessageLevel.LINT, ex);
            }

            private void report(MessageLevel level, SAXParseException ex) {
                String message = this.errorMessage(ex);
                FilePosition pos = Html5ElementStack.this.builder.getErrorLocation();
                if (message.equals(this.lastMessage) && pos.equals(this.lastPos)) {
                    return;
                }
                this.lastMessage = message;
                this.lastPos = pos;
                Html5ElementStack.this.mq.getMessages().add(new Message((MessageTypeInt)DomParserMessageType.GENERIC_SAX_ERROR, level, pos, MessagePart.Factory.valueOf(message)));
            }

            private String errorMessage(SAXParseException ex) {
                return ex.getMessage().replace('\u201c', '\'').replace('\u201d', '\'');
            }
        });
    }

    @Override
    public void finish(FilePosition endOfFile) {
        this.builder.finish(endOfFile);
        this.builder.closeUnclosedNodes();
    }

    public static String canonicalizeName(String name) {
        if (name.indexOf(58) >= 0) {
            return name;
        }
        return Strings.lower(name);
    }

    static String canonicalElementName(String elementName) {
        return Html5ElementStack.canonicalizeName(elementName);
    }

    static String canonicalAttributeName(String attributeName) {
        return Html5ElementStack.canonicalizeName(attributeName);
    }

    @Override
    public DocumentFragment getRootElement() {
        String tagName;
        Element root = this.builder.getRootElement();
        DocumentFragment result = this.doc.createDocumentFragment();
        if (this.needsDebugData) {
            Nodes.setFilePositionFor(result, this.builder.getFragmentBounds());
        }
        Node first = root.getFirstChild();
        if (!this.isFragment || this.topLevelHtmlFromInput) {
            result.appendChild(root);
            return result;
        }
        boolean tagsBesidesHeadBodyFrameset = false;
        boolean topLevelTagsWithAttributes = Html5ElementStack.hasSpecifiedAttributes(root);
        for (Node child = first; child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element el = (Element)child;
            tagName = el.getTagName();
            if (!("head".equals(tagName) || "body".equals(tagName) || "frameset".equals(tagName))) {
                tagsBesidesHeadBodyFrameset = true;
                break;
            }
            if (topLevelTagsWithAttributes || !Html5ElementStack.hasSpecifiedAttributes(el) || "frameset".equals(tagName)) continue;
            topLevelTagsWithAttributes = true;
        }
        if (tagsBesidesHeadBodyFrameset || topLevelTagsWithAttributes) {
            result.appendChild(root);
            return result;
        }
        Node pending = null;
        for (Node child = first; child != null; child = child.getNextSibling()) {
            if (child instanceof Element) {
                tagName = ((Element)child).getTagName();
                if ("head".equals(tagName) || "body".equals(tagName)) {
                    for (Node grandchild = child.getFirstChild(); grandchild != null; grandchild = grandchild.getNextSibling()) {
                        pending = this.appendNormalized(pending, grandchild, result);
                    }
                    continue;
                }
                pending = child;
                continue;
            }
            pending = this.appendNormalized(pending, child, result);
        }
        if (pending != null) {
            result.appendChild(pending);
        }
        return result;
    }

    private static boolean hasSpecifiedAttributes(Element el) {
        NamedNodeMap attrs = el.getAttributes();
        int n = attrs.getLength();
        for (int i = 0; i < n; ++i) {
            Attr a = (Attr)attrs.item(i);
            if (!el.hasAttributeNS(a.getNamespaceURI(), a.getLocalName())) continue;
            return true;
        }
        return false;
    }

    private Node appendNormalized(Node pending, Node current, DocumentFragment parent) {
        if (pending == null) {
            return current;
        }
        if (pending.getNodeType() != 3 || current.getNodeType() != 3) {
            parent.appendChild(pending);
            return current;
        }
        Text a = (Text)pending;
        Text b = (Text)current;
        Text combined = this.doc.createTextNode(a.getTextContent() + b.getTextContent());
        if (this.needsDebugData) {
            Nodes.setFilePositionFor(combined, FilePosition.span(Nodes.getFilePositionFor(a), Nodes.getFilePositionFor(b)));
            Nodes.setRawText(combined, Nodes.getRawText(a) + Nodes.getRawText(b));
        }
        return combined;
    }

    @Override
    public void processTag(Token<HtmlTokenType> start, Token<HtmlTokenType> end, List<AttrStub> attrStubs) {
        ElementName elName;
        boolean isEndTag = CajaTreeBuilder.isEndTag(start.text);
        String tagName = start.text.substring(isEndTag ? 2 : 1);
        boolean isHtml = this.checkName(tagName);
        if (isHtml) {
            tagName = Strings.lower(tagName);
        }
        HtmlAttributes htmlAttrs = new HtmlAttributes(0);
        boolean hasXmlns = false;
        List<Attr> attrs = Lists.newArrayList();
        if (!attrStubs.isEmpty()) {
            for (AttrStub as : attrStubs) {
                String qname = as.nameTok.text;
                try {
                    String name;
                    Attr attrNode;
                    boolean isAttrHtml;
                    if ("xmlns".equals(qname)) {
                        if (!"http://www.w3.org/1999/xhtml".equals(as.value)) {
                            this.mq.addMessage((MessageTypeInt)MessageType.CANNOT_OVERRIDE_DEFAULT_NAMESPACE_IN_HTML, as.nameTok.pos);
                            continue;
                        }
                        hasXmlns = true;
                        continue;
                    }
                    boolean bl = isAttrHtml = isHtml && this.checkName(qname);
                    if (isAttrHtml ? (attrNode = this.maybeCreateAttributeNs("http://www.w3.org/1999/xhtml", name = Strings.lower(qname), as)) == null : (attrNode = this.maybeCreateAttribute(name = AttributeNameFixup.fixupNameFromQname(qname), as)) == null) continue;
                    attrNode.setValue(as.value);
                    if (this.needsDebugData) {
                        Nodes.setFilePositionFor(attrNode, as.nameTok.pos);
                        Nodes.setFilePositionForValue(attrNode, as.valueTok.pos);
                        Nodes.setRawValue(attrNode, as.valueTok.text);
                    }
                    attrs.add(attrNode);
                    try {
                        htmlAttrs.addAttribute(AttributeName.nameByString((String)name), as.value, XmlViolationPolicy.ALLOW);
                    }
                    catch (SAXException ex) {
                    }
                }
                catch (DOMException ex) {
                    ex.printStackTrace();
                    this.mq.addMessage((MessageTypeInt)MessageType.INVALID_IDENTIFIER, MessageLevel.WARNING, as.nameTok.pos, MessagePart.Factory.valueOf(as.nameTok.text));
                }
            }
        }
        if ((elName = this.elNames.get(tagName)) == null) {
            elName = ElementName.elementNameByString((String)tagName);
            if (!this.checkElementNameIsValid(elName, start.pos)) {
                return;
            }
            this.elNames.put(tagName, elName);
        }
        if (this.processingFirstTag && elName == ElementName.HTML && !isEndTag) {
            this.topLevelHtmlFromInput = true;
        }
        this.processingFirstTag = false;
        try {
            if (this.builder.needsDebugData) {
                if (isEndTag && elName == ElementName.HTML) {
                    Token<HtmlTokenType> tok = Token.instance("", HtmlTokenType.TAGEND, FilePosition.startOf(start.pos));
                    if (!this.builder.wasOpened("frameset")) {
                        this.builder.setTokenContext(tok, tok);
                        if (!this.builder.wasOpened("body")) {
                            if (!this.builder.wasOpened("head")) {
                                this.builder.startTag(ElementName.HEAD, HtmlAttributes.EMPTY_ATTRIBUTES, false);
                                this.builder.endTag(ElementName.HEAD);
                            }
                            this.builder.headClosed();
                            this.builder.startTag(ElementName.BODY, HtmlAttributes.EMPTY_ATTRIBUTES, false);
                            this.builder.endTag(ElementName.BODY);
                        }
                        this.builder.bodyClosed();
                    }
                }
                this.builder.setTokenContext(start, end);
            }
            if (isEndTag) {
                this.builder.endTag(elName);
                if (this.builder.needsDebugData) {
                    if (elName == ElementName.BODY) {
                        this.builder.bodyClosed();
                    } else if (elName == ElementName.HEAD) {
                        this.builder.headClosed();
                    }
                }
            } else {
                if (hasXmlns) {
                    attrs.add(XMLNS_ATTR_MARKER);
                }
                this.builder.startTag(elName, Html5ElementStack.toHtmlAttributes(attrs, htmlAttrs), end.text.equals("/>"));
            }
        }
        catch (SAXException ex) {
            throw new SomethingWidgyHappenedError(ex);
        }
    }

    @Override
    public void processComment(Token<HtmlTokenType> commentToken) {
        char[] chars;
        int n;
        String text = commentToken.text;
        if (text.startsWith("<!--") && text.endsWith("-->")) {
            text = text.substring("<!--".length(), text.lastIndexOf("--"));
        }
        commentToken = Token.instance(text, commentToken.type, commentToken.pos);
        if (text.contains("--")) {
            this.mq.addMessage((MessageTypeInt)MessageType.INVALID_HTML_COMMENT, commentToken.pos);
        }
        if ((n = text.length()) <= this.charBuf.length) {
            chars = this.charBuf;
            text.getChars(0, n, chars, 0);
        } else {
            chars = text.toCharArray();
        }
        this.builder.setTokenContext(commentToken, commentToken);
        try {
            this.builder.comment(chars, 0, n);
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean checkName(String qname) {
        if (qname.indexOf(58, 1) < 0) {
            return true;
        }
        this.needsNamespaceFixup = true;
        return false;
    }

    private static HtmlAttributes toHtmlAttributes(List<Attr> attrs, HtmlAttributes blank) {
        HTML_ASSOCIATED_ATTRS.put(blank, attrs);
        return blank;
    }

    static List<Attr> getAssociatedAttrs(HtmlAttributes attrs) {
        List<Attr> attrList = HTML_ASSOCIATED_ATTRS.get(attrs);
        if (attrList == null) {
            attrList = Collections.emptyList();
        }
        return attrList;
    }

    @Override
    public void processText(Token<HtmlTokenType> textToken) {
        char[] chars;
        int n;
        String text = textToken.text.replaceAll("\r\n?", "\n");
        if (textToken.type == HtmlTokenType.TEXT) {
            text = this.fixBrokenEntities(text, textToken.pos);
        }
        if (text.equals(textToken.text)) {
            textToken = Token.instance(text, textToken.type, textToken.pos);
        }
        if ((n = text.length()) <= this.charBuf.length) {
            chars = this.charBuf;
            text.getChars(0, n, chars, 0);
        } else {
            chars = text.toCharArray();
        }
        this.builder.setTokenContext(textToken, textToken);
        try {
            this.builder.characters(chars, 0, n);
        }
        catch (SAXException ex) {
            throw new SomethingWidgyHappenedError(ex);
        }
    }

    @Override
    public String fixBrokenEntities(String rawText, FilePosition fp) {
        Matcher m;
        int amp = rawText.indexOf(38);
        if (amp >= 0 && (m = BROKEN_ENTITY.matcher(rawText)).find(amp)) {
            StringBuilder sb = new StringBuilder(rawText.length() + 16);
            int pos = 0;
            do {
                sb.append(rawText, pos, m.end()).append(';');
                pos = m.end();
                if (!this.needsDebugData) continue;
                this.mq.addMessage((MessageTypeInt)MessageType.MALFORMED_HTML_ENTITY, fp, MessagePart.Factory.valueOf(m.group()));
            } while (m.find());
            if (pos != 0) {
                sb.append(rawText, pos, rawText.length());
                return sb.toString();
            }
        }
        return rawText;
    }

    public Attr maybeCreateAttribute(String attrName, AttrStub as) {
        try {
            return this.doc.createAttribute(attrName);
        }
        catch (DOMException e) {
            this.mq.addMessage((MessageTypeInt)DomParserMessageType.IGNORING_TOKEN, as.nameTok.pos, MessagePart.Factory.valueOf("'" + as.nameTok.text + "'"));
            logger.log(Level.FINE, "Ignoring DOMException in maybeCreateAttribute", e);
            return null;
        }
    }

    public Attr maybeCreateAttributeNs(String nsUri, String attrName, AttrStub as) {
        try {
            return this.doc.createAttributeNS(nsUri, attrName);
        }
        catch (DOMException e) {
            this.mq.addMessage((MessageTypeInt)DomParserMessageType.IGNORING_TOKEN, as.nameTok.pos, MessagePart.Factory.valueOf("'" + as.nameTok.text + "'"));
            logger.log(Level.FINE, "Ignoring DOMException in maybeCreateAttributeNs", e);
            return null;
        }
    }

    public boolean checkElementNameIsValid(ElementName elName, FilePosition pos) {
        if (!elName.custom) {
            return true;
        }
        try {
            return this.doc.createElement(elName.name) != null;
        }
        catch (DOMException e) {
            this.mq.addMessage((MessageTypeInt)MessageType.INVALID_TAG_NAME, MessageLevel.WARNING, FilePosition.startOf(pos), MessagePart.Factory.valueOf(elName.name));
            return false;
        }
    }

    Element builderRootElement() {
        return this.builder.getRootElement();
    }
}

