/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ExpressionStmt;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.parser.js.ObjProperty;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.RenderedExpression;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.ValueProperty;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Callback;
import com.google.javascript.jscomp.jsonml.JsonML;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CajoledModule
extends AbstractParseTreeNode
implements JsonMLCompatible {
    private static final long serialVersionUID = -2499144011243193616L;

    @ParseTreeNode.ReflectiveCtor
    public CajoledModule(FilePosition pos, Void value, List<? extends ObjectConstructor> children) {
        this(pos, children.get(0));
        assert (children.size() == 1);
    }

    public CajoledModule(FilePosition pos, ObjectConstructor body) {
        super(pos, ObjectConstructor.class);
        this.createMutation().appendChild(body).execute();
    }

    public CajoledModule(ObjectConstructor body) {
        this(body.getFilePosition(), body);
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        if (this.children().size() != 1 && this.getModuleBody() != null) {
            throw new IllegalStateException("A CajoledModule may only have one child");
        }
    }

    @Override
    public Object getValue() {
        return null;
    }

    public List<? extends ObjectConstructor> children() {
        return this.childrenAs(ObjectConstructor.class);
    }

    public ObjectConstructor getModuleBody() {
        return this.children().get(0);
    }

    public String getSrc() {
        ValueProperty p = (ValueProperty)this.getModuleBody().propertyWithName("src");
        if (p == null) {
            return null;
        }
        return ((StringLiteral)p.getValueExpr()).getUnquotedValue();
    }

    public ArrayConstructor getIncludedModules() {
        ValueProperty p = (ValueProperty)this.getModuleBody().propertyWithName("includedModules");
        return p != null ? (ArrayConstructor)p.getValueExpr() : null;
    }

    public ArrayConstructor getInlinedModules() {
        ValueProperty p = (ValueProperty)this.getModuleBody().propertyWithName("inlinedModules");
        return p != null ? (ArrayConstructor)p.getValueExpr() : null;
    }

    public FunctionConstructor getInstantiateMethod() {
        return (FunctionConstructor)((ValueProperty)this.getModuleBody().propertyWithName("instantiate")).getValueExpr();
    }

    @Override
    public final TokenConsumer makeRenderer(Appendable out, Callback<IOException> exHandler) {
        return new JsPrettyPrinter(new Concatenator(out, exHandler));
    }

    @Override
    public void render(RenderContext rc) {
        this.renderModuleExpression((Expression)QuasiBuilder.substV("___.loadModule(@body)", "body", this.getModuleBody()), rc);
    }

    @Override
    public JsonML toJsonML() {
        Expression loadModuleCall = (Expression)QuasiBuilder.substV("___.loadModule(@body)", "body", this.getModuleBody());
        Block program = new Block(loadModuleCall.getFilePosition(), Collections.singletonList(new ExpressionStmt(loadModuleCall)));
        return program.toJsonMLAsProgram();
    }

    public void render(Expression callbackExpression, RenderContext rc) {
        if (callbackExpression == null) {
            this.render(rc);
        } else {
            this.renderModuleExpression((Expression)QuasiBuilder.substV("@callbackExpression(___.prepareModule(@body))", "callbackExpression", callbackExpression, "body", this.getModuleBody()), rc);
        }
    }

    private void renderModuleExpression(Expression expr, RenderContext rc) {
        Block block = new Block(FilePosition.UNKNOWN, Arrays.asList(new ExpressionStmt(FilePosition.UNKNOWN, expr)));
        block.render(rc);
    }

    public CajoledModule flatten(boolean minify) {
        ObjectConstructor oc = new ObjectConstructor(FilePosition.UNKNOWN);
        for (ObjProperty objProperty : this.getModuleBody().children()) {
            oc.appendChild(this.flattenProperty(objProperty, minify));
        }
        return new CajoledModule(oc);
    }

    private ObjProperty flattenProperty(ObjProperty op, boolean minify) {
        ValueProperty vp;
        String name;
        if (op instanceof ValueProperty && "instantiate".equals(name = (vp = (ValueProperty)op).getPropertyName())) {
            return new ValueProperty(vp.getPropertyNameNode(), new RenderedExpression(vp.getValueExpr(), minify));
        }
        return op;
    }
}

