/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.JsonMLCompatible;
import com.google.caja.parser.js.Literal;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.reporting.RenderContext;
import com.google.javascript.jscomp.jsonml.JsonML;
import com.google.javascript.jscomp.jsonml.TagAttr;
import com.google.javascript.jscomp.jsonml.TagType;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RegexpLiteral
extends Literal {
    private static final long serialVersionUID = 4158496971004173179L;
    private final RegexpWrapper value;

    @ParseTreeNode.ReflectiveCtor
    public RegexpLiteral(FilePosition pos, RegexpWrapper value, List<? extends ParseTreeNode> children) {
        this(pos, value);
    }

    public RegexpLiteral(FilePosition pos, RegexpWrapper value) {
        super(pos);
        this.value = value;
    }

    public RegexpLiteral(FilePosition pos, String value) {
        this(pos, new RegexpWrapper(value));
    }

    @Override
    public RegexpWrapper getValue() {
        return this.value;
    }

    @Override
    public void render(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        out.mark(this.getFilePosition());
        String body = this.value.getMatchText();
        String mods = this.value.getModifiers();
        if ("".equals(body) || !RegexpLiteral.areRegexpModifiersValid(mods)) {
            out.consume("(");
            out.consume("new");
            out.consume("(");
            out.consume("/./");
            out.consume(".");
            out.consume("constructor");
            out.consume(")");
            out.consume("(");
            StringLiteral.renderUnquotedValue(body, rc);
            out.consume(",");
            StringLiteral.renderUnquotedValue(mods, rc);
            out.consume(")");
            out.consume(")");
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append('/');
            Escaping.normalizeRegex((CharSequence)body, sb);
            sb.append('/');
            sb.append(mods);
            out.consume(sb.toString());
        }
    }

    @Override
    public boolean getValueInBooleanContext() {
        return true;
    }

    public static boolean areRegexpModifiersValid(String flags) {
        boolean GROUP = true;
        int CASE_INSENSITIVE = 2;
        int MULTILINE = 4;
        int seen = 0;
        int n = flags.length();
        for (int i = 0; i < n; ++i) {
            int flagMask;
            char flag = flags.charAt(i);
            switch (flag) {
                case 'g': {
                    flagMask = 1;
                    break;
                }
                case 'i': {
                    flagMask = 2;
                    break;
                }
                case 'm': {
                    flagMask = 4;
                    break;
                }
                default: {
                    return false;
                }
            }
            if ((seen & flagMask) != 0) {
                return false;
            }
            seen |= flagMask;
        }
        return true;
    }

    @Override
    public String typeOf() {
        return null;
    }

    @Override
    public JsonML toJsonML() {
        return JsonMLCompatible.JsonMLBuilder.builder(TagType.RegExpExpr, this.getFilePosition()).setAttribute(TagAttr.BODY, this.value.getMatchText()).setAttribute(TagAttr.FLAGS, this.value.getModifiers()).build();
    }

    public static class RegexpWrapper
    implements Serializable {
        private static final long serialVersionUID = -5707593923346724185L;
        private final String regexpText;

        public RegexpWrapper(String s) {
            if (null == s) {
                throw new NullPointerException();
            }
            this.regexpText = s;
        }

        public boolean equals(Object o) {
            return o instanceof RegexpWrapper && ((RegexpWrapper)o).regexpText.equals(this.regexpText);
        }

        public int hashCode() {
            return this.regexpText.hashCode() ^ 0x8AED26A5;
        }

        public String toString() {
            return this.regexpText;
        }

        public static RegexpWrapper valueOf(String pattern, String modifiers) {
            StringBuilder sb = new StringBuilder();
            sb.append('/');
            Escaping.normalizeRegex((CharSequence)pattern, sb);
            sb.append('/').append(modifiers);
            return new RegexpWrapper(sb.toString());
        }

        public String getMatchText() {
            return this.regexpText.substring(1, this.regexpText.lastIndexOf(47));
        }

        public String getModifiers() {
            return this.regexpText.substring(this.regexpText.lastIndexOf(47) + 1);
        }
    }
}

