/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.js;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.AbstractStatement;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Statement;
import com.google.caja.reporting.RenderContext;
import com.google.javascript.jscomp.jsonml.JsonML;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TranslatedCode
extends AbstractStatement {
    private static final long serialVersionUID = -6877925345465957418L;

    @ParseTreeNode.ReflectiveCtor
    public TranslatedCode(FilePosition pos, Void value, List<? extends Statement> children) {
        super(pos, Block.class);
        this.appendChild(children.get(0));
        assert (children.size() == 1);
    }

    public TranslatedCode(Block body) {
        super(body.getFilePosition(), Block.class);
        this.appendChild(body);
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        if (this.children().size() != 1) {
            throw new IllegalStateException("TranslatedCode may only have one child");
        }
        ParseTreeNode module = this.children().get(0);
        if (!(module instanceof Statement)) {
            throw new ClassCastException("Expected block, not " + module);
        }
    }

    @Override
    public Object getValue() {
        return null;
    }

    public List<? extends Block> children() {
        return this.childrenAs(Block.class);
    }

    public Block getTranslation() {
        return this.children().get(0);
    }

    @Override
    public void render(RenderContext rc) {
        TokenConsumer out = rc.getOut();
        out.consume("/* Start translated code */");
        out.consume("throw");
        out.consume("'Translated code must never be executed'");
        out.consume(";");
        this.children().get(0).render(rc);
        out.consume("/* End translated code */");
    }

    @Override
    public boolean hasHangingConditional() {
        return false;
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    @Override
    public JsonML toJsonML() {
        return this.getTranslation().toJsonML();
    }
}

