/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.quasiliteral.Rule;
import com.google.caja.parser.quasiliteral.RuleChain;
import com.google.caja.util.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RuleFilter<KeyT> {
    private final RuleChain ruleChain;
    private final Map<KeyT, List<Rule>> cache = Maps.newHashMap();
    private static boolean debug = false;

    public RuleFilter(RuleChain ruleChain) {
        this.ruleChain = ruleChain;
    }

    public void reset() {
        this.cache.clear();
    }

    public List<Rule> rulesFor(ParseTreeNode node) {
        KeyT key = this.getKey(node);
        if (key == null) {
            return this.ruleChain.getAllRules();
        }
        List<Rule> someRules = this.cache.get(key);
        if (someRules == null) {
            someRules = this.computeRulesFor(key);
            this.cache.put(key, someRules);
            if (debug) {
                this.debugShowRules(someRules, node);
            }
        }
        return someRules;
    }

    private List<Rule> computeRulesFor(KeyT key) {
        ArrayList<Rule> someRules = new ArrayList<Rule>();
        for (Rule rule : this.ruleChain.getAllRules()) {
            if (!this.canMatch(rule, key)) continue;
            someRules.add(rule);
        }
        return Collections.unmodifiableList(someRules);
    }

    private void debugShowRules(List<Rule> someRules, ParseTreeNode node) {
        System.err.println(someRules.size() + " rules for " + node);
        StringBuilder names = new StringBuilder("  ");
        int ll = 2;
        for (Rule rule : someRules) {
            String name = rule.getName();
            if (75 < (ll += 1 + name.length())) {
                names.append("\n  ");
                ll = 3 + name.length();
            }
            names.append(" ").append(name);
        }
        System.err.println(names);
    }

    abstract KeyT getKey(ParseTreeNode var1);

    abstract boolean canMatch(Rule var1, KeyT var2);
}

