/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lang.html.HTML;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.CssTokenType;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.lexer.escaping.UriUtil;
import com.google.caja.parser.css.CssParser;
import com.google.caja.parser.html.AttribKey;
import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.stages.EmbeddedContent;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.ContentType;
import com.google.caja.util.Function;
import com.google.caja.util.Lists;
import com.google.caja.util.Strings;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlEmbeddedContentFinder {
    private final HtmlSchema schema;
    private final URI baseUri;
    private final MessageQueue mq;
    private final MessageContext mc;
    private static final ElKey LINK = ElKey.forHtmlElement("link");
    private static final ElKey SCRIPT = ElKey.forHtmlElement("script");
    private static final ElKey STYLE = ElKey.forHtmlElement("style");
    private static final AttribKey LINK_HREF = AttribKey.forHtmlAttrib(LINK, "href");
    private static final AttribKey LINK_REL = AttribKey.forHtmlAttrib(LINK, "rel");
    private static final AttribKey SCRIPT_DEFER = AttribKey.forHtmlAttrib(ElKey.HTML_WILDCARD, "defer");
    private static final AttribKey SCRIPT_SRC = AttribKey.forHtmlAttrib(SCRIPT, "src");
    private static final AttribKey TYPE = AttribKey.forHtmlAttrib(ElKey.HTML_WILDCARD, "type");

    public HtmlEmbeddedContentFinder(HtmlSchema schema, URI baseUri, MessageQueue mq, MessageContext mc) {
        assert (schema != null && mq != null && baseUri.isAbsolute() && !baseUri.isOpaque());
        this.schema = schema;
        this.baseUri = baseUri;
        this.mq = mq;
        this.mc = mc;
    }

    public Iterable<EmbeddedContent> findEmbeddedContent(Node node) {
        List<EmbeddedContent> out = Lists.newArrayList();
        this.findEmbeddedContent(node, out);
        return out;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    private void findEmbeddedContent(Node node, List<EmbeddedContent> out) {
        if (node instanceof Element) {
            Element el = (Element)node;
            ElKey key = ElKey.forElement(el);
            ContentType expected = null;
            ExternalReference extRef = null;
            String defaultMimeType = null;
            boolean deferred = false;
            if (SCRIPT.equals(key)) {
                expected = ContentType.JS;
                extRef = this.externalReferenceFromAttr(el, SCRIPT_SRC);
                deferred = Strings.eqIgnoreCase("defer", el.getAttributeNS(HtmlEmbeddedContentFinder.SCRIPT_DEFER.ns.uri, HtmlEmbeddedContentFinder.SCRIPT_DEFER.localName));
            } else if (STYLE.equals(key)) {
                expected = ContentType.CSS;
            } else if (LINK.equals(key) && Strings.eqIgnoreCase("stylesheet", el.getAttributeNS(HtmlEmbeddedContentFinder.LINK_REL.ns.uri, HtmlEmbeddedContentFinder.LINK_REL.localName)) && (extRef = this.externalReferenceFromAttr(el, LINK_HREF)) != null) {
                expected = ContentType.CSS;
                defaultMimeType = ContentType.CSS.mimeType;
            }
            if (expected != null) {
                ContentType contentType;
                String mimeType = this.getMimeTypeFromHtmlTypeAttribute(el, key);
                if (mimeType == null) {
                    mimeType = defaultMimeType;
                }
                ContentType contentType2 = contentType = mimeType != null ? ContentType.fromMimeType(mimeType) : null;
                if (contentType == expected) {
                    if (extRef == null) {
                        out.add(this.fromElementBody(el, expected, deferred));
                    } else {
                        out.add(this.fromExternalReference(el, expected, extRef, deferred));
                    }
                } else {
                    FilePosition typePos = Nodes.getFilePositionFor(el);
                    Attr a = el.getAttributeNodeNS(HtmlEmbeddedContentFinder.TYPE.ns.uri, HtmlEmbeddedContentFinder.TYPE.localName);
                    if (a != null) {
                        typePos = Nodes.getFilePositionForValue(a);
                    }
                    this.mq.addMessage((MessageTypeInt)PluginMessageType.UNRECOGNIZED_CONTENT_TYPE, typePos, MessagePart.Factory.valueOf(mimeType), key);
                    out.add(this.fromBadContent(el));
                }
            }
            for (Attr attr : Nodes.attributesOf(el)) {
                AttribKey aKey = AttribKey.forAttribute(key, attr);
                HTML.Attribute aInfo = this.schema.lookupAttribute(aKey);
                if (aInfo == null) continue;
                switch (aInfo.getType()) {
                    case URI: {
                        boolean isCode = false;
                        try {
                            String uriText = UriUtil.normalizeUri(attr.getValue());
                            URI uri = new URI(uriText);
                            if (Strings.eqIgnoreCase("javascript", uri.getScheme())) {
                                isCode = true;
                            }
                        }
                        catch (URISyntaxException ex) {
                            // empty catch block
                        }
                        if (!isCode) break;
                        out.add(this.fromAttrib(attr, true, ContentType.JS));
                        break;
                    }
                    case SCRIPT: {
                        out.add(this.fromAttrib(attr, false, ContentType.JS));
                        break;
                    }
                    case STYLE: {
                        out.add(this.fromAttrib(attr, false, ContentType.CSS));
                        break;
                    }
                }
            }
        }
        for (Node c = node.getFirstChild(); c != null; c = c.getNextSibling()) {
            this.findEmbeddedContent(c, out);
        }
    }

    private EmbeddedContent fromExternalReference(Element el, final ContentType t, final ExternalReference extRef, boolean deferred) {
        return new EmbeddedContent(this, extRef.getReferencePosition(), new Function<UriFetcher, CharProducer>(){
            boolean loaded;
            CharProducer cp = null;

            @Override
            public CharProducer apply(UriFetcher fetcher) {
                if (!this.loaded) {
                    URI uri = extRef.getUri();
                    ExternalReference toLoad = extRef;
                    if (!uri.isAbsolute() && HtmlEmbeddedContentFinder.this.baseUri != null) {
                        toLoad = new ExternalReference(HtmlEmbeddedContentFinder.this.baseUri.resolve(uri), extRef.getReferencePosition());
                    }
                    try {
                        this.cp = fetcher.fetch(toLoad, t.mimeType).getTextualContent();
                    }
                    catch (UriFetcher.UriFetchException ex) {
                        this.cp = null;
                    }
                    catch (UnsupportedEncodingException ex) {
                        this.cp = null;
                    }
                    HtmlEmbeddedContentFinder.this.mc.addInputSource(new InputSource(toLoad.getUri()));
                    this.loaded = true;
                }
                if (this.cp == null) {
                    URI srcUri = extRef.getUri();
                    String errUri = srcUri.isAbsolute() ? HtmlEmbeddedContentFinder.this.mc.abbreviate(new InputSource(srcUri)) : srcUri.toString();
                    HtmlEmbeddedContentFinder.this.mq.addMessage((MessageTypeInt)PluginMessageType.FAILED_TO_LOAD_EXTERNAL_URL, extRef.getReferencePosition(), MessagePart.Factory.valueOf(errUri));
                    switch (t) {
                        case JS: {
                            this.cp = CharProducer.Factory.fromString((CharSequence)("throw new Error(" + StringLiteral.toQuotedValue("Failed to load " + errUri) + ");"), extRef.getReferencePosition());
                            break;
                        }
                        case CSS: {
                            this.cp = CharProducer.Factory.fromString((CharSequence)("/* Failed to load " + errUri.replaceAll("\\*/", "* /") + " */"), extRef.getReferencePosition());
                            break;
                        }
                        default: {
                            throw new SomethingWidgyHappenedError(t.toString());
                        }
                    }
                }
                return this.cp.clone();
            }
        }, extRef, deferred, el, t);
    }

    private EmbeddedContent fromElementBody(Element el, ContentType t, boolean deferred) {
        final CharProducer cp = HtmlEmbeddedContentFinder.textNodesToCharProducer(el, t == ContentType.JS);
        return new EmbeddedContent(this, cp.filePositionForOffsets(0, cp.getLimit()), new Function<UriFetcher, CharProducer>(){

            @Override
            public CharProducer apply(UriFetcher fetcher) {
                return cp.clone();
            }
        }, null, deferred, el, t);
    }

    private EmbeddedContent fromAttrib(final Attr a, final boolean uriDecode, ContentType t) {
        final String rawValue = Nodes.getRawValue(a);
        final String value = a.getValue();
        return new EmbeddedContent(this, Nodes.getFilePositionForValue(a), new Function<UriFetcher, CharProducer>(){
            CharProducer cp;

            @Override
            public CharProducer apply(UriFetcher fetcher) {
                if (this.cp == null) {
                    CharProducer cp;
                    char lastCh;
                    int n;
                    String rawText = rawValue;
                    if (rawText != null && (n = rawText.length()) >= 2 && ((lastCh = rawText.charAt(n - 1)) == '\"' || lastCh == '\'')) {
                        rawText = rawText.charAt(0) == lastCh ? " " + rawText.substring(1, n - 1) + " " : rawText.substring(0, n - 1) + " ";
                    }
                    if (rawText != null && Nodes.decode(rawText).trim().equals(value.trim())) {
                        if (uriDecode) {
                            rawText = HtmlEmbeddedContentFinder.blankOutScheme(rawText);
                        }
                        cp = CharProducer.Factory.fromHtmlAttribute(CharProducer.Factory.fromString((CharSequence)rawText, Nodes.getFilePositionForValue(a)));
                    } else {
                        String decodedText = value;
                        if (uriDecode) {
                            decodedText = HtmlEmbeddedContentFinder.blankOutScheme(decodedText);
                        }
                        cp = CharProducer.Factory.fromString((CharSequence)decodedText, Nodes.getFilePositionForValue(a));
                    }
                    if (uriDecode) {
                        cp = CharProducer.Factory.fromUri(cp);
                    }
                    this.cp = cp;
                }
                return this.cp.clone();
            }
        }, null, false, a, t);
    }

    private EmbeddedContent fromBadContent(Element el) {
        final FilePosition pos = FilePosition.startOf(Nodes.getFilePositionFor(el));
        return new EmbeddedContent(this, pos, new Function<UriFetcher, CharProducer>(){

            @Override
            public CharProducer apply(UriFetcher fetcher) {
                return CharProducer.Factory.fromString((CharSequence)"", pos);
            }
        }, null, false, el, null);
    }

    private ExternalReference externalReferenceFromAttr(Element el, AttribKey a) {
        URI uri;
        Attr attr = el.getAttributeNodeNS(a.ns.uri, a.localName);
        if (attr == null || "".equals(attr.getValue())) {
            return null;
        }
        try {
            uri = new URI(attr.getNodeValue());
        }
        catch (URISyntaxException ex) {
            this.mq.getMessages().add(new Message((MessageTypeInt)PluginMessageType.MALFORMED_URL, MessageLevel.ERROR, Nodes.getFilePositionFor(attr), a));
            return null;
        }
        return new ExternalReference(uri, Nodes.getFilePositionForValue(attr));
    }

    /*
     * WARNING - void declaration
     */
    private static CharProducer textNodesToCharProducer(Element el, boolean stripComments) {
        void var4_6;
        List<Text> textNodes = Lists.newArrayList();
        for (Node node : Nodes.childrenOf(el)) {
            if (!(node instanceof Text)) continue;
            textNodes.add((Text)node);
        }
        if (textNodes.isEmpty()) {
            return CharProducer.Factory.create(new StringReader(""), FilePosition.endOf(Nodes.getFilePositionFor(el)));
        }
        List<CharProducer> content = Lists.newArrayList();
        boolean bl = false;
        int n = textNodes.size();
        while (var4_6 < n) {
            Text node = (Text)textNodes.get((int)var4_6);
            String text = node.getNodeValue();
            if (stripComments) {
                if (var4_6 == false) {
                    text = text.replaceFirst("^(\\s*)<!--", "$1     ");
                }
                if (var4_6 + true == n) {
                    text = text.replaceFirst("-->(\\s*)$", "   $1");
                }
            }
            content.add(CharProducer.Factory.create(new StringReader(text), FilePosition.startOf(Nodes.getFilePositionFor(node))));
            ++var4_6;
        }
        if (content.size() == 1) {
            return (CharProducer)content.get(0);
        }
        return CharProducer.Factory.chain(content.toArray(new CharProducer[0]));
    }

    private String getMimeTypeFromHtmlTypeAttribute(Element el, ElKey elKey) {
        Attr type = el.getAttributeNodeNS(HtmlEmbeddedContentFinder.TYPE.ns.uri, HtmlEmbeddedContentFinder.TYPE.localName);
        if (type != null) {
            return type.getValue();
        }
        HTML.Attribute attr = this.schema.lookupAttribute(TYPE.onElement(elKey));
        if (attr == null) {
            return null;
        }
        return attr.getDefaultValue();
    }

    protected boolean shouldAllowJsQuasis() {
        return false;
    }

    protected boolean shouldJsRecover() {
        return false;
    }

    protected boolean shouldAllowCssSubsts() {
        return false;
    }

    protected MessageLevel getCssTolerance() {
        return MessageLevel.WARNING;
    }

    Parser makeJsParser(CharProducer cp, MessageQueue mq) {
        boolean quasis = this.shouldAllowJsQuasis();
        FilePosition p = cp.filePositionForOffsets(cp.getOffset(), cp.getLimit());
        JsLexer lexer = new JsLexer(cp, quasis);
        JsTokenQueue tq = new JsTokenQueue(lexer, p.source());
        tq.setInputRange(p);
        Parser parser = new Parser(tq, mq, quasis);
        parser.setRecoverFromFailure(this.shouldJsRecover());
        return parser;
    }

    CssParser makeCssParser(CharProducer cp, MessageQueue mq) {
        boolean allowSubsts = this.shouldAllowCssSubsts();
        FilePosition p = cp.filePositionForOffsets(cp.getOffset(), cp.getLimit());
        TokenQueue<CssTokenType> tq = CssParser.makeTokenQueue(cp, mq, allowSubsts);
        tq.setInputRange(p);
        return new CssParser(tq, mq, this.getCssTolerance());
    }

    private static String blankOutScheme(String s) {
        int colon = s.indexOf(58);
        StringBuilder sb = new StringBuilder(s);
        int i = colon + 1;
        while (--i >= 0) {
            char ch = sb.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            sb.setCharAt(i, ' ');
        }
        return sb.toString();
    }
}

