/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.precajole;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.precajole.PrecajoleMap;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Strings;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticPrecajoleMap
implements PrecajoleMap {
    private static String SUBDIR_PATH = "com/google/caja/precajole/data/";
    private static String INDEX_NAME = "index.dat";
    private final String dir;
    private final Index index;

    public static StaticPrecajoleMap getInstance() {
        return InstanceHolder.instance;
    }

    public StaticPrecajoleMap(File baseDir) {
        this(baseDir.toString());
    }

    public StaticPrecajoleMap(String baseDir) {
        if (!baseDir.equals("") && !baseDir.endsWith("/")) {
            baseDir = baseDir + "/";
        }
        this.dir = baseDir + SUBDIR_PATH;
        this.index = this.readIndex();
    }

    private Index readIndex() {
        Object o = StaticPrecajoleMap.deserialize(this.load(INDEX_NAME));
        if (o != null && o instanceof Index) {
            return (Index)o;
        }
        return new Index();
    }

    public void put(List<String> uris, String source, CajoledModule cajoled) {
        this.put(uris.toArray(new String[uris.size()]), source, cajoled);
    }

    public void put(String[] uris, String source, CajoledModule cajoled) {
        Entry entry = new Entry(uris, source, cajoled);
        byte[] serial = StaticPrecajoleMap.serialize(entry);
        for (int k = 0; k < uris.length; ++k) {
            this.index.map.put(StaticPrecajoleMap.normalizeUri(uris[k]), entry.id);
        }
        this.save(entry.id, serial);
    }

    public long getModTime() {
        return this.index.modTime;
    }

    public void setModTime(long millitime) {
        this.index.modTime = millitime;
    }

    public void finish() {
        this.save(INDEX_NAME, StaticPrecajoleMap.serialize(this.index));
    }

    @Override
    public CajoledModule lookupUri(String uri, boolean minify) {
        Entry e = Entry.from(this.load(this.idForUri(uri)));
        if (e != null && e.uris != null) {
            for (int k = 0; k < e.uris.length; ++k) {
                if (!uri.equals(e.uris[k])) continue;
                return minify ? e.minified : e.pretty;
            }
        }
        return null;
    }

    @Override
    public CajoledModule lookupSource(String source, boolean minify) {
        Entry e = Entry.from(this.load(StaticPrecajoleMap.idForSource(source = StaticPrecajoleMap.normalizeSource(source))));
        if (e != null && source.equals(e.source)) {
            return minify ? e.minified : e.pretty;
        }
        return null;
    }

    public List<List<String>> getUrlGroups() {
        Map idMap = Maps.newHashMap();
        for (String url : this.index.map.keySet()) {
            String id = this.index.map.get(url);
            List<String> urls = (List<String>)idMap.get(id);
            if (urls == null) {
                urls = Lists.newArrayList();
                idMap.put(id, urls);
            }
            urls.add(url);
        }
        List<List<String>> urlGroups = Lists.newArrayList();
        for (List urls : idMap.values()) {
            urlGroups.add(urls);
        }
        return urlGroups;
    }

    public static String normalizeUri(String uri) {
        try {
            URI u = new URI(uri).normalize();
            if (u.getHost() != null) {
                u = new URI(StaticPrecajoleMap.lowercase(u.getScheme()), u.getUserInfo(), StaticPrecajoleMap.lowercase(u.getHost()), u.getPort(), u.getPath(), u.getQuery(), u.getFragment());
            } else if (u.getScheme() != null) {
                u = new URI(StaticPrecajoleMap.lowercase(u.getScheme()), u.getSchemeSpecificPart(), u.getFragment());
            }
            return u.toString();
        }
        catch (URISyntaxException e) {
            return uri;
        }
    }

    private static String lowercase(String s) {
        return s == null ? null : Strings.lower(s);
    }

    private void save(String id, byte[] data) {
        try {
            new File(this.dir).mkdirs();
            FileOutputStream o = new FileOutputStream(new File(this.dir, id));
            o.write(data);
            o.close();
        }
        catch (IOException e) {
            throw new SomethingWidgyHappenedError(e);
        }
    }

    private String idForUri(String uri) {
        return this.index.map.get(StaticPrecajoleMap.normalizeUri(uri));
    }

    private static String idForSource(String source) {
        return StaticPrecajoleMap.computeHash(source);
    }

    private static String normalizeSource(String source) {
        return source.trim();
    }

    private byte[] load(String id) {
        byte[] result = this.loadResource(id);
        return result != null ? result : this.loadFile(id);
    }

    private byte[] loadFile(String id) {
        if (id == null) {
            return null;
        }
        try {
            return Files.toByteArray((File)new File(this.dir, id));
        }
        catch (IOException e) {
            return null;
        }
    }

    private byte[] loadResource(String id) {
        if (id == null) {
            return null;
        }
        ClassLoader cl = StaticPrecajoleMap.class.getClassLoader();
        InputStream is = cl.getResourceAsStream(this.dir + id);
        if (is == null) {
            return null;
        }
        try {
            return ByteStreams.toByteArray((InputStream)is);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String computeHash(String s) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            byte[] digest = sha1.digest(s.getBytes("UTF-8"));
            return new String(Hex.encodeHex((byte[])digest));
        }
        catch (NoSuchAlgorithmException e) {
            throw new SomethingWidgyHappenedError(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new SomethingWidgyHappenedError(e);
        }
    }

    private static byte[] serialize(Object obj) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            ObjectOutputStream ostr = new ObjectOutputStream(buf);
            ostr.writeObject(obj);
            ostr.close();
        }
        catch (IOException e) {
            throw new SomethingWidgyHappenedError(e);
        }
        return buf.toByteArray();
    }

    private static Object deserialize(byte[] serial) {
        if (serial == null) {
            return null;
        }
        try {
            ByteArrayInputStream b = new ByteArrayInputStream(serial);
            ObjectInputStream i = new ObjectInputStream(b);
            return i.readObject();
        }
        catch (IOException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static class Index
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Map<String, String> map = Maps.newHashMap();
        public long modTime = 0L;

        private Index() {
        }
    }

    private static class Entry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final String[] uris;
        final String source;
        final CajoledModule minified;
        final CajoledModule pretty;
        final String id;

        Entry(String[] uris, String source, CajoledModule cajoled) {
            this.uris = uris;
            this.source = StaticPrecajoleMap.normalizeSource(source);
            this.minified = cajoled.flatten(true);
            this.pretty = cajoled.flatten(false);
            this.id = StaticPrecajoleMap.idForSource(this.source);
        }

        static Entry from(byte[] serial) {
            return (Entry)StaticPrecajoleMap.deserialize(serial);
        }
    }

    private static class InstanceHolder {
        static StaticPrecajoleMap instance = new StaticPrecajoleMap("");

        private InstanceHolder() {
        }
    }
}

