/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.reporting;

import com.google.caja.lexer.TokenConsumer;
import com.google.caja.reporting.JsIdentifierSyntax;
import com.google.caja.reporting.MarkupRenderMode;
import com.google.caja.reporting.PropertyNameQuotingMode;

public class RenderContext {
    private final MarkupRenderMode markupMode;
    private final PropertyNameQuotingMode propertyNameQuotingMode;
    private final JsIdentifierSyntax jsIdentifierSyntax;
    private final TokenConsumer out;

    public RenderContext(TokenConsumer out) {
        this(out, MarkupRenderMode.HTML, PropertyNameQuotingMode.DEFAULT, JsIdentifierSyntax.DEFAULT);
    }

    private RenderContext(TokenConsumer out, MarkupRenderMode markupMode, PropertyNameQuotingMode propertyNameQuotingMode, JsIdentifierSyntax jsIdentifierSyntax) {
        if (null == out) {
            throw new NullPointerException();
        }
        this.markupMode = markupMode;
        this.propertyNameQuotingMode = propertyNameQuotingMode;
        this.jsIdentifierSyntax = jsIdentifierSyntax;
        this.out = out;
    }

    public final boolean asJson() {
        return this.propertyNameQuotingMode == PropertyNameQuotingMode.DOUBLE_QUOTES;
    }

    public final boolean asXml() {
        return this.markupMode == MarkupRenderMode.XML;
    }

    public final MarkupRenderMode markupRenderMode() {
        return this.markupMode;
    }

    public final PropertyNameQuotingMode propertyNameQuotingMode() {
        return this.propertyNameQuotingMode;
    }

    public final JsIdentifierSyntax jsIdentifierSyntax() {
        return this.jsIdentifierSyntax;
    }

    public final TokenConsumer getOut() {
        return this.out;
    }

    private RenderContext derive(MarkupRenderMode markupMode, PropertyNameQuotingMode propertyNameQuotingMode, JsIdentifierSyntax jsIdentifierSyntax) {
        return new RenderContext(this.out, markupMode, propertyNameQuotingMode, jsIdentifierSyntax);
    }

    public RenderContext withJson(boolean b) {
        return this.withPropertyNameQuotingMode(b ? PropertyNameQuotingMode.DOUBLE_QUOTES : PropertyNameQuotingMode.DEFAULT);
    }

    public RenderContext withMarkupRenderMode(MarkupRenderMode markupMode) {
        return markupMode != this.markupMode ? this.derive(markupMode, this.propertyNameQuotingMode, this.jsIdentifierSyntax) : this;
    }

    public RenderContext withPropertyNameQuotingMode(PropertyNameQuotingMode m) {
        return this.propertyNameQuotingMode != m ? this.derive(this.markupMode, m, this.jsIdentifierSyntax) : this;
    }

    public RenderContext withJsIdentiferSyntax(JsIdentifierSyntax s) {
        return this.jsIdentifierSyntax != s ? this.derive(this.markupMode, this.propertyNameQuotingMode, s) : this;
    }

    @Deprecated
    public final boolean isEmbeddable() {
        return true;
    }

    @Deprecated
    public final boolean isAsciiOnly() {
        return true;
    }

    @Deprecated
    public final boolean rawObjKeys() {
        return this.propertyNameQuotingMode == PropertyNameQuotingMode.NO_QUOTES;
    }

    @Deprecated
    public RenderContext withAsciiOnly(boolean b) {
        return this;
    }

    @Deprecated
    public RenderContext withEmbeddable(boolean b) {
        return this;
    }

    @Deprecated
    public RenderContext withAsXml(boolean b) {
        return this.withMarkupRenderMode(b ? MarkupRenderMode.XML : MarkupRenderMode.HTML);
    }

    @Deprecated
    public RenderContext withRawObjKeys(boolean b) {
        return b ? this.withPropertyNameQuotingMode(PropertyNameQuotingMode.NO_QUOTES) : this.withPropertyNameQuotingMode(PropertyNameQuotingMode.DEFAULT);
    }
}

