/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.parser.ParserContext;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.quasiliteral.ES53Rewriter;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.service.AbstractCajolingHandler;
import com.google.caja.service.CajaArguments;
import com.google.caja.service.CajolingService;
import com.google.caja.service.ContentHandlerArgs;
import com.google.caja.service.ContentTypeCheck;
import com.google.caja.service.UnsupportedContentTypeException;
import com.google.caja.util.Charsets;
import com.google.caja.util.ContentType;
import com.google.caja.util.Pair;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsHandler
extends AbstractCajolingHandler {
    public JsHandler(BuildInfo buildInfo) {
        super(buildInfo, null, null);
    }

    @Override
    public boolean canHandle(URI uri, CajolingService.Transform transform, List<CajolingService.Directive> directives, String inputContentType, ContentTypeCheck checker) {
        return checker.check("text/javascript", inputContentType) && (transform == null || transform == CajolingService.Transform.CAJOLE);
    }

    @Override
    public Pair<String, String> apply(URI uri, CajolingService.Transform transform, List<CajolingService.Directive> directive, ContentHandlerArgs args, String inputContentType, ContentTypeCheck checker, FetchedData input, OutputStream response, MessageQueue mq) throws UnsupportedContentTypeException {
        Pair<ContentType, String> contentParams = JsHandler.getReturnedContentParams(args);
        boolean pretty = "pretty".equals(CajaArguments.RENDERER.get(args));
        try {
            OutputStreamWriter writer = new OutputStreamWriter(response, Charsets.UTF_8.name());
            this.cajoleJs(uri, input.getTextualContent(), (String)contentParams.b, writer, pretty, mq);
            writer.flush();
        }
        catch (IOException e) {
            throw new UnsupportedContentTypeException();
        }
        return Pair.pair(((ContentType)((Object)contentParams.a)).mimeType, Charsets.UTF_8.name());
    }

    private void cajoleJs(URI inputUri, CharProducer cp, String jsonpCallback, Appendable output, boolean pretty, MessageQueue mq) {
        CajoledModule cajoledModule = null;
        try {
            Block input = (Block)new ParserContext(mq).withInput(new InputSource(inputUri)).withInput(ContentType.JS).withInput(cp).build();
            UncajoledModule ucm = new UncajoledModule(input);
            ES53Rewriter esrw = new ES53Rewriter(this.buildInfo, mq, false);
            cajoledModule = (CajoledModule)esrw.expand(ucm);
        }
        catch (ParseException e) {
            e.toMessageQueue(mq);
        }
        catch (IllegalStateException e) {
            mq.addMessage((MessageTypeInt)MessageType.INTERNAL_ERROR, MessagePart.Factory.valueOf(e.getMessage()));
        }
        catch (IOException e) {
            // empty catch block
        }
        if (mq.hasMessageAtLevel(MessageLevel.ERROR)) {
            cajoledModule = null;
        }
        try {
            JsHandler.renderAsJSON(null, cajoledModule, jsonpCallback, mq, output, pretty);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

