/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.tools;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.escaping.Escaping;
import com.google.caja.tools.BuildCommand;
import com.google.caja.util.Charsets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsToVar
implements BuildCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean build(List<File> inputs, List<File> dependencies, Map<String, Object> options, File output) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(output), Charsets.UTF_8.name());
        String currentDate = "" + new Date();
        if (currentDate.indexOf("*/") >= 0) {
            throw new SomethingWidgyHappenedError("Date should not contain '*/'");
        }
        out.write("/* Copyright Google Inc.\n");
        out.write(" * Licensed under the Apache Licence Version 2.0\n");
        out.write(" * Autogenerated at " + currentDate + "\n");
        out.write(" */\n");
        try {
            out.write("var ");
            Escaping.escapeJsIdentifier((CharSequence)this.varName(output), true, out);
            out.write(" = ");
            ((Writer)out).write(34);
            Escaping.escapeJsString((CharSequence)this.concatFiles(inputs), true, true, out);
            ((Writer)out).write(34);
            ((Writer)out).write(59);
        }
        finally {
            ((Writer)out).close();
        }
        return true;
    }

    private String varName(File output) {
        String name = output.getName();
        return name.endsWith(".js") ? name.substring(0, name.length() - 3) : name;
    }

    private String concatFiles(Iterable<? extends File> inputs) throws IOException {
        StringBuilder result = new StringBuilder();
        for (File file : inputs) {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = null;
            while (null != (line = reader.readLine())) {
                result.append(line + "\n");
            }
        }
        return result.toString();
    }
}

