/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.tools;

import com.google.caja.util.FailureIsAnOption;
import java.io.File;
import java.lang.reflect.Method;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class TestSummary
extends Task {
    private FileSet testResults;
    private String errorProperty;
    private String failureProperty;
    private static final String U_FAILURES = "failures";
    private static final String U_ERRORS = "errors";
    private static final String E_FAILURES = "expected-failures";
    private static final String E_ERRORS = "expected-errors";

    public void execute() {
        if (this.testResults == null) {
            throw new BuildException("Please specify a test summary file via the testSummary attribute");
        }
        boolean isFailureAnOptionOverride = !"true".equals(this.getProject().getProperty("test.failureNotAnOption"));
        this.log("failureAnOption=" + isFailureAnOptionOverride, 3);
        int errors = 0;
        int failures = 0;
        int expectedErrors = 0;
        int expectedFailures = 0;
        DirectoryScanner scanner = this.testResults.getDirectoryScanner(this.getProject());
        File baseDir = scanner.getBasedir();
        scanner.scan();
        for (String resultFileName : scanner.getIncludedFiles()) {
            Document result;
            File resultFile = new File(baseDir, resultFileName);
            if (resultFile.length() == 0L) continue;
            this.log("processing file " + resultFileName, 3);
            try {
                StreamSource src = new StreamSource(resultFile);
                DOMResult out = new DOMResult();
                TransformerFactory.newInstance().newTransformer().transform(src, out);
                result = (Document)out.getNode();
            }
            catch (TransformerException ex) {
                throw new BuildException("Failed to read test input from " + resultFileName, (Throwable)ex);
            }
            NodeList testCases = result.getElementsByTagName("testcase");
            if (testCases.getLength() == 0) {
                errors += result.getElementsByTagName("error").getLength();
            }
            int n = testCases.getLength();
            for (int i = 0; i < n; ++i) {
                int e;
                int f;
                boolean isFailureAllowed;
                Method method;
                Element testCase = (Element)testCases.item(i);
                String className = testCase.getAttribute("classname");
                String methodName = testCase.getAttribute("name");
                try {
                    Class<?> testClass = Class.forName(className);
                    method = testClass.getMethod(methodName, new Class[0]);
                }
                catch (ClassNotFoundException ex) {
                    throw new BuildException("Cannot find class " + className, (Throwable)ex);
                }
                catch (NoSuchMethodException ex) {
                    throw new BuildException("Cannot find method " + methodName + " of " + className, (Throwable)ex);
                }
                boolean isFailureExpected = method.isAnnotationPresent(FailureIsAnOption.class);
                boolean bl = isFailureAllowed = isFailureAnOptionOverride && isFailureExpected;
                if (isFailureAllowed) {
                    this.log("Failure is an option for " + className + "." + methodName, 3);
                    f = TestSummary.rewriteChildElements(testCase, "failure", "expected-failure");
                    e = TestSummary.rewriteChildElements(testCase, "error", "expected-error");
                    int nErrors = testCase.getElementsByTagName("expected-error").getLength();
                    int nFailures = testCase.getElementsByTagName("expected-failure").getLength();
                    expectedErrors += nErrors;
                    expectedFailures += nFailures;
                    if (nErrors == 0 && nFailures == 0 && isFailureExpected) {
                        this.hero(className, methodName);
                    }
                    testCase.setAttribute("expected", "true");
                    TestSummary.subtract(e, f, (Element)testCase.getParentNode());
                    continue;
                }
                f = TestSummary.rewriteChildElements(testCase, "expected-failure", "failure");
                e = TestSummary.rewriteChildElements(testCase, "expected-error", "error");
                testCase.removeAttribute("expected");
                TestSummary.subtract(-e, -f, (Element)testCase.getParentNode());
                failures += testCase.getElementsByTagName("failure").getLength();
                errors += testCase.getElementsByTagName("error").getLength();
            }
            try {
                DOMSource src = new DOMSource(result);
                StreamResult out = new StreamResult(resultFile);
                TransformerFactory.newInstance().newTransformer().transform(src, out);
            }
            catch (TransformerException ex) {
                throw new BuildException("Failed to write result " + resultFileName);
            }
        }
        if (this.failureProperty != null && failures != 0) {
            this.getProject().setProperty(this.failureProperty, "" + failures);
        }
        if (this.errorProperty != null && errors != 0) {
            this.getProject().setProperty(this.errorProperty, "" + errors);
        }
        if (errors | expectedErrors | failures | expectedFailures) {
            this.log("Errors: " + errors + ", Failures: " + failures + ", Expected Errors: " + expectedErrors + ", Expected Failures: " + expectedFailures, 1);
        }
    }

    private void hero(String className, String testName) {
        this.log("Expected failure but " + testName + " on " + className + " succeeded", 2);
    }

    private static void subtract(int nErrors, int nFailures, Element el) {
        while ("testsuite".equals(el.getTagName())) {
            TestSummary.adjAttr(el, U_ERRORS, -nErrors);
            TestSummary.adjAttr(el, U_FAILURES, -nFailures);
            TestSummary.adjAttr(el, E_ERRORS, nErrors);
            TestSummary.adjAttr(el, E_FAILURES, nFailures);
            Node parent = el.getParentNode();
            if (!(parent instanceof Element)) break;
            el = (Element)parent;
        }
    }

    private static void adjAttr(Element el, String attrName, int delta) {
        String value = el.getAttribute(attrName);
        int num = "".equals(value) ? 0 : Integer.parseInt(value);
        el.setAttribute(attrName, "" + (num + delta));
    }

    private static int rewriteChildElements(Element parent, String oldName, String newName) {
        int nRewritten = 0;
        for (Node c = parent.getFirstChild(); c != null; c = c.getNextSibling()) {
            if (!(c instanceof Element) || !oldName.equals(c.getNodeName())) continue;
            Element el = (Element)c;
            Element replacement = parent.getOwnerDocument().createElement(newName);
            while (el.getFirstChild() != null) {
                replacement.appendChild(el.getFirstChild());
            }
            NamedNodeMap attrMap = el.getAttributes();
            Attr[] attrs = new Attr[attrMap.getLength()];
            int n = attrMap.getLength();
            for (int i = 0; i < n; ++i) {
                attrs[i] = (Attr)attrMap.item(i);
            }
            for (Attr attr : attrs) {
                el.removeAttributeNode(attr);
                replacement.setAttributeNode(attr);
            }
            parent.replaceChild(replacement, el);
            ++nRewritten;
        }
        return nRewritten;
    }

    public void setErrorProperty(String name) {
        this.errorProperty = name;
    }

    public void setFailureProperty(String name) {
        this.failureProperty = name;
    }

    public FileSet createFileSet() {
        if (this.testResults != null) {
            throw new BuildException("Can only have one file set");
        }
        this.testResults = new FileSet();
        return this.testResults;
    }
}

