/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;

public class TemplateParamsProcessor
extends BaseActivityProcessorPlugin {
    private static final Log LOG = ExoLogger.getLogger(TemplateParamsProcessor.class);
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("\\$\\{([^}]*)}");

    public TemplateParamsProcessor(InitParams params) {
        super(params);
    }

    @Override
    public void processActivity(ExoSocialActivity activity) {
        try {
            Map params = activity.getTemplateParams();
            activity.setTitle(this.processTemplate(activity.getTitle(), params));
            activity.setBody(this.processTemplate(activity.getBody(), params));
        }
        catch (Exception e) {
            LOG.error((Object)"TemplateParamsProcessor error : ", (Throwable)e);
        }
    }

    private String processTemplate(String template, Map<String, String> params) throws Exception {
        if (template == null) {
            return template;
        }
        Matcher matcher = PARAMETER_PATTERN.matcher(template);
        int index = 0;
        while (matcher.find(index)) {
            index = matcher.end();
            String templateKey = matcher.group();
            String key = matcher.group(1);
            String value = params.get(key);
            if (value == null) continue;
            template = template.replace(templateKey, value);
        }
        return template;
    }
}

