/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.Media;

class ParentChainIterator {
    private ASTCssNode currentNode;
    private ASTCssNode currentNodeParent;

    public ParentChainIterator(Media media) {
        this.currentNode = media;
        this.currentNodeParent = this.currentNode.getParent();
    }

    public ASTCssNode getCurrentNode() {
        return this.currentNode;
    }

    public Body getParentAsBody() {
        return (Body)this.currentNodeParent;
    }

    public void moveUpToNextBody() {
        this.moveOnParent();
        while (!this.finished() && !this.onNextBody()) {
            this.moveOnParent();
        }
    }

    private boolean onNextBody() {
        return this.currentNodeParent instanceof Body;
    }

    private void moveOnParent() {
        this.currentNode = this.currentNodeParent;
        this.currentNodeParent = this.currentNode.getParent();
    }

    public boolean finished() {
        return this.isStopParent(this.currentNodeParent);
    }

    private boolean isStopParent(ASTCssNode parent) {
        if (parent == null) {
            return true;
        }
        switch (parent.getType()) {
            case STYLE_SHEET: {
                return true;
            }
            case GENERAL_BODY: {
                GeneralBody body = (GeneralBody)parent;
                ASTCssNode bodyParent = body.getParent();
                return bodyParent == null || bodyParent.getType() == ASTCssNodeType.MEDIA;
            }
        }
        return false;
    }
}

