/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Import;
import com.github.sommeri.less4j.core.compiler.expressions.TypesConversionUtils;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.ArrayList;

public class UrlsAndImportsNormalizer {
    private TypesConversionUtils conversionUtils = new TypesConversionUtils();
    private final ProblemsHandler problemsHandler;

    public UrlsAndImportsNormalizer(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    public void normalizeUrlsAndImports(ASTCssNode node) {
        switch (node.getType()) {
            case IMPORT: {
                this.normalizeImport((Import)node);
                break;
            }
            default: {
                ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
                for (ASTCssNode aSTCssNode : childs) {
                    this.normalizeUrlsAndImports(aSTCssNode);
                }
            }
        }
    }

    private void normalizeImport(Import node) {
        String extractFilename = this.conversionUtils.extractFilename(node.getUrlExpression(), this.problemsHandler);
    }
}

