/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.js;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.uri.JsUriManager;

public class JsRequest {
    private final JsUriManager.JsUri jsUri;
    private final String host;
    private final boolean inCache;
    private final FeatureRegistry registry;
    private List<String> allFeatures;
    private List<String> newFeatures;
    private List<String> loadedFeatures;

    JsRequest(JsUriManager.JsUri jsUri, String host, boolean inCache, FeatureRegistry registry) {
        this.jsUri = jsUri;
        this.host = host;
        this.inCache = inCache;
        this.registry = registry;
    }

    public JsUriManager.JsUri getJsUri() {
        return this.jsUri;
    }

    public String getHost() {
        return this.host;
    }

    public boolean isInCache() {
        return this.inCache;
    }

    public List<String> getAllFeatures() {
        this.initFeaturesLists();
        return this.allFeatures;
    }

    public List<String> getNewFeatures() {
        this.initFeaturesLists();
        return this.newFeatures;
    }

    public List<String> getLoadedFeatures() {
        this.initFeaturesLists();
        return this.loadedFeatures;
    }

    private void initFeaturesLists() {
        if (this.allFeatures == null) {
            this.allFeatures = this.registry.getFeatures(this.jsUri.getLibs());
            this.loadedFeatures = this.registry.getFeatures(this.jsUri.getLoadedLibs());
            this.newFeatures = Lists.newLinkedList();
            for (String candidate : this.allFeatures) {
                if (this.loadedFeatures.contains(candidate)) continue;
                this.newFeatures.add(candidate);
            }
        }
    }
}

