/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.js;

import java.util.Collections;
import java.util.List;
import org.apache.shindig.gadgets.js.JsContent;

public class JsResponse {
    private final List<JsContent> jsCode;
    private final List<String> errors;
    private final String externs;
    private final int cacheTtlSecs;
    private final int statusCode;
    private final boolean proxyCacheable;
    private String codeString;
    private String errorString;

    JsResponse(List<JsContent> jsCode, int statusCode, int cacheTtlSecs, boolean proxyCacheable, List<String> errors, String externs) {
        this.jsCode = Collections.unmodifiableList(jsCode);
        this.errors = Collections.unmodifiableList(errors);
        this.statusCode = statusCode;
        this.cacheTtlSecs = cacheTtlSecs;
        this.proxyCacheable = proxyCacheable;
        this.externs = externs;
    }

    public String toJsString() {
        if (this.codeString == null) {
            StringBuilder sb = new StringBuilder();
            for (JsContent js : this.getAllJsContent()) {
                sb.append(js.get());
            }
            this.codeString = sb.toString();
        }
        return this.codeString;
    }

    public Iterable<JsContent> getAllJsContent() {
        return this.jsCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean isError() {
        return this.statusCode >= 400;
    }

    public int getCacheTtlSecs() {
        return this.cacheTtlSecs;
    }

    public boolean isProxyCacheable() {
        return this.proxyCacheable;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public String toErrorString() {
        if (this.errorString == null) {
            StringBuilder sb = new StringBuilder();
            for (String error : this.getErrors()) {
                sb.append(error);
            }
            this.errorString = sb.toString();
        }
        return this.errorString;
    }

    public String getExterns() {
        return this.externs;
    }
}

