/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.Map;
import org.apache.shindig.auth.AbstractSecurityToken;

public class OAuth2CallbackStateToken
extends AbstractSecurityToken
implements Serializable {
    private static final long serialVersionUID = -3913197153778386101L;
    private static final EnumSet<AbstractSecurityToken.Keys> MAP_KEYS = EnumSet.of(AbstractSecurityToken.Keys.EXPIRES);
    private static final String GADGET_URI = "g";
    private static final String SERVICE_NAME = "sn";
    private static final String USER = "u";
    private static final String SCOPE = "sc";
    private String gadgetUri;
    private String serviceName;
    private String user;
    private String scope;

    OAuth2CallbackStateToken() {
    }

    public OAuth2CallbackStateToken(Map<String, String> values) {
        this.loadFromMap(values);
    }

    protected AbstractSecurityToken loadFromMap(Map<String, String> map) {
        String sc;
        String u;
        String sn;
        super.loadFromMap(map);
        String g = map.get(GADGET_URI);
        if (g != null) {
            this.setGadgetUri(g);
        }
        if ((sn = map.get(SERVICE_NAME)) != null) {
            this.setServiceName(sn);
        }
        if ((u = map.get(USER)) != null) {
            this.setUser(u);
        }
        if ((sc = map.get(SCOPE)) != null) {
            this.setScope(sc);
        }
        return this;
    }

    public String getUpdatedToken() {
        return null;
    }

    public String getAuthenticationMode() {
        return null;
    }

    public boolean isAnonymous() {
        return false;
    }

    protected EnumSet<AbstractSecurityToken.Keys> getMapKeys() {
        return MAP_KEYS;
    }

    public String getGadgetUri() {
        return this.gadgetUri;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getUser() {
        return this.user;
    }

    public String getScope() {
        return this.scope;
    }

    public OAuth2CallbackStateToken setGadgetUri(String gadgetUri) {
        this.gadgetUri = gadgetUri;
        return this;
    }

    public OAuth2CallbackStateToken setServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public OAuth2CallbackStateToken setUser(String user) {
        this.user = user;
        return this;
    }

    public OAuth2CallbackStateToken setScope(String scope) {
        this.scope = scope;
        return this;
    }

    protected int getMaxTokenTTL() {
        return 600;
    }

    public Map<String, String> toMap() {
        String sc;
        String u;
        String sn;
        Map map = super.toMap();
        String g = this.getGadgetUri();
        if (g != null) {
            map.put(GADGET_URI, g);
        }
        if ((sn = this.getServiceName()) != null) {
            map.put(SERVICE_NAME, sn);
        }
        if ((u = this.getUser()) != null) {
            map.put(USER, u);
        }
        if ((sc = this.getScope()) != null) {
            map.put(SCOPE, sc);
        }
        return map;
    }
}

