/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import com.google.caja.lexer.escaping.Escaping;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Set;
import org.apache.shindig.gadgets.parse.HtmlSerializer;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class HtmlSerialization {
    public static final String KEY = "serializer";
    private static final String ORIGINAL_LENGTH = "original-length";
    public static final Set<String> URL_ATTRIBUTES = ImmutableSet.of((Object)"href", (Object)"src");

    public static void attach(Document doc, HtmlSerializer serializer, String originalContent) {
        doc.setUserData(KEY, serializer, null);
        if (originalContent != null) {
            doc.setUserData(ORIGINAL_LENGTH, originalContent.length(), null);
        }
    }

    static void copySerializer(Document from, Document to) {
        Integer length = (Integer)from.getUserData(ORIGINAL_LENGTH);
        if (length != null) {
            to.setUserData(ORIGINAL_LENGTH, length, null);
        }
        to.setUserData(KEY, from.getUserData(KEY), null);
    }

    private static int getOriginalLength(Document doc) {
        Integer length = (Integer)doc.getUserData(ORIGINAL_LENGTH);
        if (length == null) {
            return -1;
        }
        return length;
    }

    public static StringWriter createWriter(Document doc) {
        int originalLength = HtmlSerialization.getOriginalLength(doc);
        if (originalLength == -1) {
            return new StringWriter(8192);
        }
        return new StringWriter(originalLength * 11 / 10);
    }

    public static String serialize(Document doc) {
        return ((HtmlSerializer)doc.getUserData(KEY)).serialize(doc);
    }

    public static void printEscapedText(CharSequence text, Appendable output) throws IOException {
        Escaping.escapeXml((CharSequence)text, (boolean)true, (Appendable)output);
    }

    public static void printStartElement(Element elem, Appendable output, boolean withXmlClose) throws IOException {
        HtmlSerialization.printStartElement(elem.getTagName(), elem.getAttributes(), output, withXmlClose);
    }

    public static void printStartElement(String tagName, NamedNodeMap attributes, Appendable output, boolean withXmlClose) throws IOException {
        output.append("<").append(tagName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            String attrName = attr.getNodeName();
            output.append(' ').append(attrName);
            if (attr.getNodeValue() == null) continue;
            output.append("=\"");
            if (attr.getNodeValue().length() != 0) {
                HtmlSerialization.printEscapedText(attr.getNodeValue(), output);
            }
            output.append('\"');
        }
        output.append(withXmlClose ? "/>" : ">");
    }

    public static void outputDocType(DocumentType docType, Appendable output) throws IOException {
        output.append("<!DOCTYPE ");
        output.append(docType.getOwnerDocument().getDocumentElement().getNodeName());
        if (docType.getPublicId() != null && docType.getPublicId().length() > 0) {
            output.append(" ");
            output.append("PUBLIC ").append('\"').append(docType.getPublicId()).append('\"');
        }
        if (docType.getSystemId() != null && docType.getSystemId().length() > 0) {
            output.append(" ");
            output.append('\"').append(docType.getSystemId()).append('\"');
        }
        output.append(">\n");
    }

    public static boolean isUrlAttribute(QName name, String attributeName) {
        return name.uri == null && URL_ATTRIBUTES.contains(attributeName);
    }
}

