/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.image;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.rewrite.image.BaseOptimizer;
import org.apache.shindig.gadgets.rewrite.image.ImageUtils;
import org.apache.shindig.gadgets.rewrite.image.JPEGOptimizer;
import org.apache.shindig.gadgets.rewrite.image.OptimizerConfig;

class PNGOptimizer
extends BaseOptimizer {
    private boolean useJpeg;

    public static BufferedImage readPng(InputStream is) throws ImageReadException, IOException {
        return Sanselan.getBufferedImage((InputStream)is);
    }

    public PNGOptimizer(OptimizerConfig config, HttpResponseBuilder response) {
        super(config, response);
    }

    @Override
    protected void rewriteImpl(BufferedImage bufferedImage) throws IOException {
        boolean isOpaque;
        BufferedImage palettized = ImageUtils.palettize(bufferedImage, this.config.getMaxPaletteSize());
        if (palettized != null) {
            this.write(palettized);
        }
        if (palettized == null) {
            BufferedImage depalettized;
            if (this.minBytes == null) {
                this.write(bufferedImage);
            }
            if ((depalettized = ImageUtils.depalettize(bufferedImage, this.config.getMaxInMemoryBytes())) != null) {
                this.write(depalettized);
            }
        }
        if (this.config.isJpegConversionAllowed() && (isOpaque = palettized != null ? (bufferedImage = palettized).getColorModel().getTransparency() == 1 : ImageUtils.isOpaque(bufferedImage))) {
            byte[] lastBytes = this.minBytes;
            int prevReductionPct = this.reductionPct;
            BufferedImage rgbOnlyImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
            rgbOnlyImage.getGraphics().drawImage(bufferedImage, 0, 0, null);
            JPEGOptimizer jpegOptimizer = new JPEGOptimizer(this.config, this.response);
            this.outputter = jpegOptimizer.getOutputter();
            this.write(rgbOnlyImage);
            if (this.reductionPct > prevReductionPct + 20) {
                this.useJpeg = true;
            } else {
                this.minBytes = lastBytes;
            }
        }
    }

    @Override
    protected String getOutputContentType() {
        if (this.useJpeg) {
            return "image/jpeg";
        }
        return "image/png";
    }

    @Override
    protected String getOriginalContentType() {
        return "image/png";
    }

    @Override
    protected String getOriginalFormatName() {
        return "png";
    }
}

