/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.common.util.OpenSocialVersion;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.ExternalServices;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.spec.View;
import org.apache.shindig.gadgets.variables.Substitutions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GadgetSpec {
    public static final String DEFAULT_VIEW = "default";
    public static final Locale DEFAULT_LOCALE = new Locale("all", "ALL");
    private static final String ATTR_SPECIFICATION_VERSION = "specificationVersion";
    public static final String DOCTYPE_QUIRKSMODE = "quirksmode";
    private final Uri url;
    private final String checksum;
    protected ModulePrefs modulePrefs;
    protected Map<String, UserPref> userPrefs;
    protected Map<String, View> views;
    protected ExternalServices externalServices;
    private final Map<String, Object> attributes = new MapMaker().makeMap();

    public GadgetSpec(Uri url, Element doc, String original) throws SpecParserException {
        this.url = url;
        this.checksum = HashUtil.checksum((byte[])original.getBytes());
        NodeList children = doc.getChildNodes();
        this.setAttribute(ATTR_SPECIFICATION_VERSION, doc.getAttribute(ATTR_SPECIFICATION_VERSION));
        ModulePrefs modulePrefs = null;
        LinkedHashMap prefsBuilder = Maps.newLinkedHashMap();
        LinkedHashMap views = Maps.newLinkedHashMap();
        int j = children.getLength();
        for (int i = 0; i < j; ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            Element element = (Element)child;
            String name = element.getTagName();
            if ("ModulePrefs".equals(name)) {
                if (modulePrefs == null) {
                    modulePrefs = new ModulePrefs(element, url);
                } else {
                    throw new SpecParserException("Only 1 ModulePrefs is allowed.");
                }
            }
            if ("UserPref".equals(name)) {
                UserPref pref = new UserPref(element);
                if (prefsBuilder.containsKey(pref.getName())) {
                    throw new SpecParserException("Duplicate value for user pref " + pref.getName());
                }
                prefsBuilder.put(pref.getName(), pref);
            }
            if ("Content".equals(name)) {
                String viewNames = XmlUtil.getAttribute((Node)element, (String)"view", (String)DEFAULT_VIEW);
                for (String view : Splitter.on((char)',').trimResults().split((CharSequence)viewNames)) {
                    List viewElements = (List)views.get(view);
                    if (viewElements == null) {
                        viewElements = Lists.newLinkedList();
                        views.put(view, viewElements);
                    }
                    viewElements.add(element);
                }
            }
            if (!"ExternalServices".equals(name)) continue;
            if (this.externalServices != null) {
                throw new SpecParserException("Only 1 ExternalServices is allowed.");
            }
            this.externalServices = new ExternalServices(element);
        }
        if (modulePrefs == null) {
            throw new SpecParserException("At least 1 ModulePrefs is required.");
        }
        this.modulePrefs = modulePrefs;
        if (views.isEmpty()) {
            throw new SpecParserException("At least 1 Content is required.");
        }
        HashMap tmpViews = Maps.newHashMap();
        for (Map.Entry view : views.entrySet()) {
            View v = new View((String)view.getKey(), (List)view.getValue(), url);
            tmpViews.put(v.getName(), v);
        }
        this.views = ImmutableMap.copyOf((Map)tmpViews);
        this.userPrefs = ImmutableMap.copyOf((Map)prefsBuilder);
    }

    @VisibleForTesting
    public GadgetSpec(Uri url, String xml) throws SpecParserException {
        this(url, XmlUtil.parseSilent((String)xml), xml);
    }

    protected GadgetSpec(GadgetSpec spec) {
        this.url = spec.url;
        this.checksum = spec.checksum;
        this.attributes.putAll(spec.attributes);
    }

    public OpenSocialVersion getSpecificationVersion() {
        String value = (String)this.attributes.get(ATTR_SPECIFICATION_VERSION);
        if (value == null) {
            return new OpenSocialVersion("1.0");
        }
        return new OpenSocialVersion(value);
    }

    public Uri getUrl() {
        return this.url;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public ModulePrefs getModulePrefs() {
        return this.modulePrefs;
    }

    public Map<String, UserPref> getUserPrefs() {
        return this.userPrefs;
    }

    public Map<String, View> getViews() {
        return this.views;
    }

    public ExternalServices getExternalServices() {
        return this.externalServices;
    }

    public View getView(String name) {
        return this.views.get(name);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object o) {
        this.attributes.put(key, o);
    }

    public GadgetSpec substitute(Substitutions substituter) {
        GadgetSpec spec = new GadgetSpec(this);
        spec.modulePrefs = this.modulePrefs.substitute(substituter);
        if (this.userPrefs.isEmpty()) {
            spec.userPrefs = ImmutableMap.of();
        } else {
            ImmutableMap.Builder prefs = ImmutableMap.builder();
            for (UserPref pref : this.userPrefs.values()) {
                prefs.put((Object)pref.getName(), (Object)pref.substitute(substituter));
            }
            spec.userPrefs = prefs.build();
        }
        ImmutableMap.Builder viewMap = ImmutableMap.builder();
        for (View view : this.views.values()) {
            viewMap.put((Object)view.getName(), (Object)view.substitute(substituter));
        }
        spec.views = viewMap.build();
        return spec;
    }

    public GadgetSpec removeUrlViews() {
        GadgetSpec spec = new GadgetSpec(this);
        spec.modulePrefs = this.modulePrefs;
        spec.userPrefs = this.userPrefs;
        ImmutableMap.Builder viewMap = ImmutableMap.builder();
        for (View view : this.views.values()) {
            if (view.getType() == View.ContentType.URL) continue;
            viewMap.put((Object)view.getName(), (Object)view);
        }
        spec.views = viewMap.build();
        return spec;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<Module>\n").append(this.modulePrefs).append('\n');
        for (UserPref userPref : this.userPrefs.values()) {
            buf.append(userPref).append('\n');
        }
        for (Map.Entry entry : this.views.entrySet()) {
            buf.append(entry.getValue()).append('\n');
        }
        buf.append("</Module>");
        return buf.toString();
    }
}

