/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.oauth2.OAuth2Arguments;
import org.apache.shindig.gadgets.uri.ProxyUriBase;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.apache.shindig.gadgets.uri.UriStatus;

public interface ProxyUriManager {
    public List<Uri> make(List<ProxyUri> var1, Integer var2);

    public ProxyUri process(Uri var1) throws GadgetException;

    public static interface Versioner {
        public List<String> version(List<Uri> var1, String var2, List<String> var3);

        public UriStatus validate(Uri var1, String var2, String var3);
    }

    public static class ProxyUri
    extends ProxyUriBase {
        private final Uri resource;
        private String fallbackUrl;
        private Integer resizeHeight;
        private Integer resizeWidth;
        private Integer resizeQuality;
        private boolean resizeNoExpand;
        private SecurityToken securityToken;
        private AuthType authType;
        private OAuth2Arguments oauth2Arguments;
        private OAuthArguments oauthArguments;
        @VisibleForTesting
        String returnOriginalContentOnError;
        private String htmlTagContext;
        private String userAgent;

        public ProxyUri(Gadget gadget, Uri resource) {
            super(gadget);
            this.resource = resource;
            if ("accel".equals(gadget.getContext().getContainer())) {
                this.setReturnOriginalContentOnError(true);
            }
            if (this.authType == null) {
                this.authType = AuthType.NONE;
            }
        }

        public ProxyUri(Integer refresh, boolean debug, boolean noCache, String container, String gadget, Uri resource) {
            super(UriStatus.VALID_UNVERSIONED, refresh, debug, noCache, container, gadget);
            this.resource = resource;
            if ("accel".equals(container)) {
                this.setReturnOriginalContentOnError(true);
            }
            if (this.authType == null) {
                this.authType = AuthType.NONE;
            }
        }

        public ProxyUri(UriStatus status, Uri resource, Uri base) {
            super(status, base);
            this.resource = resource;
        }

        @VisibleForTesting
        public void setReturnOriginalContentOnError(boolean returnOriginalContentOnError) {
            this.returnOriginalContentOnError = returnOriginalContentOnError ? "1" : null;
        }

        public void setUserAgent(String ua) {
            this.userAgent = ua;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public void setHtmlTagContext(String htmlTagContext) {
            this.htmlTagContext = htmlTagContext;
        }

        public String getHtmlTagContext() {
            return this.htmlTagContext;
        }

        public SecurityToken getSecurityToken() {
            return this.securityToken;
        }

        public AuthType getAuthType() {
            return this.authType;
        }

        public OAuthArguments getOAuthArguments() {
            return this.oauthArguments;
        }

        public OAuth2Arguments getOAuth2Arguments() {
            return this.oauth2Arguments;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ProxyUri)) {
                return false;
            }
            ProxyUri objUri = (ProxyUri)obj;
            return super.equals(obj) && Objects.equal((Object)this.resource, (Object)objUri.resource) && Objects.equal((Object)this.fallbackUrl, (Object)objUri.fallbackUrl) && Objects.equal((Object)this.resizeHeight, (Object)objUri.resizeHeight) && Objects.equal((Object)this.resizeWidth, (Object)objUri.resizeWidth) && Objects.equal((Object)this.resizeQuality, (Object)objUri.resizeQuality) && Objects.equal((Object)this.resizeNoExpand, (Object)objUri.resizeNoExpand) && Objects.equal((Object)this.returnOriginalContentOnError, (Object)objUri.returnOriginalContentOnError) && Objects.equal((Object)this.htmlTagContext, (Object)objUri.htmlTagContext) && Objects.equal((Object)this.securityToken, (Object)objUri.securityToken) && Objects.equal((Object)((Object)this.authType), (Object)((Object)objUri.authType)) && Objects.equal((Object)this.oauthArguments, (Object)objUri.oauthArguments) && Objects.equal((Object)this.oauth2Arguments, (Object)objUri.oauth2Arguments);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.resource, this.fallbackUrl, this.resizeHeight, this.resizeWidth, this.resizeQuality, this.resizeNoExpand, this.returnOriginalContentOnError, this.htmlTagContext, this.securityToken, this.authType, this.oauthArguments, this.oauth2Arguments});
        }

        @Override
        public void setFromUri(Uri uri) {
            super.setFromUri(uri);
            if (uri != null) {
                this.fallbackUrl = uri.getQueryParameter(UriCommon.Param.FALLBACK_URL_PARAM.getKey());
                this.resizeHeight = ProxyUri.getIntegerValue(uri.getQueryParameter(UriCommon.Param.RESIZE_HEIGHT.getKey()));
                this.resizeWidth = ProxyUri.getIntegerValue(uri.getQueryParameter(UriCommon.Param.RESIZE_WIDTH.getKey()));
                this.resizeQuality = ProxyUri.getIntegerValue(uri.getQueryParameter(UriCommon.Param.RESIZE_QUALITY.getKey()));
                this.resizeNoExpand = ProxyUri.getBooleanValue(uri.getQueryParameter(UriCommon.Param.NO_EXPAND.getKey()));
                this.returnOriginalContentOnError = uri.getQueryParameter(UriCommon.Param.RETURN_ORIGINAL_CONTENT_ON_ERROR.getKey());
                this.htmlTagContext = uri.getQueryParameter(UriCommon.Param.HTML_TAG_CONTEXT.getKey());
                this.authType = AuthType.parse(uri.getQueryParameter(UriCommon.Param.AUTHZ.getKey()));
            }
        }

        public ProxyUri setResize(Integer w, Integer h, Integer q, boolean noExpand) {
            this.resizeHeight = h;
            this.resizeWidth = w;
            this.resizeQuality = q;
            this.resizeNoExpand = noExpand;
            return this;
        }

        public ProxyUri setFallbackUrl(String fallbackUrl) {
            this.fallbackUrl = fallbackUrl;
            return this;
        }

        public ProxyUri setSecurityToken(SecurityToken securityToken) {
            this.securityToken = securityToken;
            return this;
        }

        public ProxyUri setAuthType(AuthType authType) {
            this.authType = authType;
            return this;
        }

        public ProxyUri setOAuthArguments(OAuthArguments oauthArgments) {
            this.oauthArguments = oauthArgments;
            return this;
        }

        public ProxyUri setOAuth2Arguments(OAuth2Arguments oauth2Arguments) {
            this.oauth2Arguments = oauth2Arguments;
            return this;
        }

        public Uri getResource() {
            return this.resource;
        }

        public Uri getFallbackUri() throws GadgetException {
            if (this.fallbackUrl == null) {
                return null;
            }
            try {
                return Uri.parse((String)this.fallbackUrl);
            }
            catch (IllegalArgumentException e) {
                throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, UriCommon.Param.FALLBACK_URL_PARAM.getKey() + " param is invalid: " + e, 400);
            }
        }

        public boolean shouldReturnOrigOnErr() {
            return "1".equals(this.returnOriginalContentOnError) || "true".equalsIgnoreCase(this.returnOriginalContentOnError);
        }

        @Override
        public UriBuilder makeQueryParams(Integer forcedRefresh, String version) {
            UriBuilder builder = super.makeQueryParams(forcedRefresh, version);
            if (this.resizeHeight != null) {
                builder.addQueryParameter(UriCommon.Param.RESIZE_HEIGHT.getKey(), this.resizeHeight.toString());
            }
            if (this.resizeWidth != null) {
                builder.addQueryParameter(UriCommon.Param.RESIZE_WIDTH.getKey(), this.resizeWidth.toString());
            }
            if (this.resizeQuality != null) {
                builder.addQueryParameter(UriCommon.Param.RESIZE_QUALITY.getKey(), this.resizeQuality.toString());
            }
            if (this.resizeNoExpand) {
                builder.addQueryParameter(UriCommon.Param.NO_EXPAND.getKey(), "1");
            }
            if (this.fallbackUrl != null) {
                builder.addQueryParameter(UriCommon.Param.FALLBACK_URL_PARAM.getKey(), this.fallbackUrl);
            }
            if (this.returnOriginalContentOnError != null) {
                builder.addQueryParameter(UriCommon.Param.RETURN_ORIGINAL_CONTENT_ON_ERROR.getKey(), this.returnOriginalContentOnError);
            }
            if (this.htmlTagContext != null) {
                builder.addQueryParameter(UriCommon.Param.HTML_TAG_CONTEXT.getKey(), this.htmlTagContext);
            }
            return builder;
        }

        @Override
        public HttpRequest makeHttpRequest(Uri targetUri) throws GadgetException {
            HttpRequest req = super.makeHttpRequest(targetUri);
            req.setParam(UriCommon.Param.RESIZE_HEIGHT.getKey(), this.resizeHeight);
            req.setParam(UriCommon.Param.RESIZE_WIDTH.getKey(), this.resizeWidth);
            req.setParam(UriCommon.Param.RESIZE_QUALITY.getKey(), this.resizeQuality);
            req.setParam(UriCommon.Param.NO_EXPAND.getKey(), this.resizeNoExpand ? "1" : "0");
            req.setParam(UriCommon.Param.RETURN_ORIGINAL_CONTENT_ON_ERROR.getKey(), this.returnOriginalContentOnError);
            req.setParam(UriCommon.Param.HTML_TAG_CONTEXT.getKey(), this.htmlTagContext);
            req.setSecurityToken(this.securityToken);
            req.setAuthType(this.authType);
            if (AuthType.OAUTH.equals((Object)this.authType)) {
                req.setOAuthArguments(this.oauthArguments);
            } else if (AuthType.OAUTH2.equals((Object)this.authType)) {
                req.setOAuth2Arguments(this.oauth2Arguments);
            }
            return req;
        }

        public static List<ProxyUri> fromList(Gadget gadget, List<Uri> uris) {
            ArrayList res = Lists.newArrayListWithCapacity((int)uris.size());
            for (Uri uri : uris) {
                res.add(new ProxyUri(gadget, uri));
            }
            return res;
        }
    }
}

