/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.embedder;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.ws.rs.core.UriBuilder;
import org.exoplatform.commons.embedder.Embedder;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.Log;
import org.json.JSONObject;

public abstract class AbstractEmbedder
implements Embedder {
    protected Map<Pattern, String> schemeEndpointMap = new HashMap<Pattern, String>();
    protected String url;
    private Pattern pattern;

    AbstractEmbedder(InitParams initParams) {
        Iterator it = initParams.getValueParamIterator();
        ValueParam valueParam = null;
        while (it.hasNext()) {
            valueParam = (ValueParam)it.next();
            String reg = this.getValue(valueParam.getName());
            String feedsURL = this.getValue(valueParam.getValue());
            this.pattern = Pattern.compile(reg);
            this.schemeEndpointMap.put(this.pattern, feedsURL);
        }
    }

    protected Pattern getPattern() {
        return this.pattern;
    }

    private String getValue(String input) {
        return input.replaceAll("&amp;", "&");
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    public String correctURIString(String uriString, String scheme, boolean force) {
        URI uri = UriBuilder.fromUri((String)uriString).build(new Object[0]);
        if (uri.getScheme() == null || force) {
            uri = UriBuilder.fromUri((String)uri.toString()).scheme(scheme).build(new Object[0]);
        }
        return uri.toString();
    }

    protected JSONObject getJSONObject(URL url) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuffer stringBuffer = new StringBuffer();
            String eachLine = null;
            while ((eachLine = bufferedReader.readLine()) != null) {
                stringBuffer.append(eachLine);
            }
            bufferedReader.close();
            return new JSONObject(stringBuffer.toString());
        }
        catch (Exception e) {
            this.getExoLogger().warn((Object)("Can't get json from url: " + url.toString()));
            return null;
        }
    }

    protected abstract Log getExoLogger();
}

