/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.LinkedList;
import java.util.List;
import org.exoplatform.calendar.model.Calendar;
import org.exoplatform.calendar.model.CompositeID;
import org.exoplatform.calendar.model.query.CalendarQuery;
import org.exoplatform.calendar.service.CalendarHandler;
import org.exoplatform.calendar.service.impl.ExtendedCalendarServiceImpl;
import org.exoplatform.calendar.storage.CalendarDAO;
import org.exoplatform.calendar.storage.Storage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CalendarHandlerImpl
implements CalendarHandler {
    private static final Log log = ExoLogger.getExoLogger(CalendarHandlerImpl.class);
    private ExtendedCalendarServiceImpl service;

    public CalendarHandlerImpl(ExtendedCalendarServiceImpl service) {
        this.service = service;
    }

    @Override
    public Calendar getCalendarById(String compositeId) {
        CompositeID composId = CompositeID.parse(compositeId);
        if (composId.getDS() != null) {
            Calendar cal;
            Storage storage = this.service.lookForDS(composId.getDS());
            CalendarDAO dao = storage.getCalendarDAO();
            if (dao != null && (cal = (Calendar)dao.getById(composId.getId())) != null) {
                return cal;
            }
        } else {
            for (Storage storage : this.service.getAllStorage()) {
                Calendar cal;
                CalendarDAO dao = storage.getCalendarDAO();
                if (dao == null || (cal = (Calendar)dao.getById(composId.getId())) == null) continue;
                return cal;
            }
        }
        return null;
    }

    @Override
    public List<Calendar> findCalendars(CalendarQuery query) {
        LinkedList<Calendar> calendars = new LinkedList<Calendar>();
        for (Storage storage : this.service.getAllStorage()) {
            List<Calendar> cals = storage.getCalendarDAO().findCalendars(query);
            if (cals == null) continue;
            calendars.addAll(cals);
        }
        return calendars;
    }

    @Override
    public Calendar saveCalendar(Calendar calendar) {
        Calendar cal;
        Storage storage = this.service.lookForDS(calendar.getDS());
        CalendarDAO dao = storage.getCalendarDAO();
        if (dao != null && (cal = dao.save(calendar)) != null) {
            return cal;
        }
        return null;
    }

    @Override
    public Calendar updateCalendar(Calendar calendar) {
        Storage storage = this.service.lookForDS(calendar.getDS());
        CalendarDAO dao = storage.getCalendarDAO();
        if (dao != null) {
            return dao.update(calendar);
        }
        return null;
    }

    @Override
    public Calendar removeCalendar(String compositeId) {
        Calendar cal;
        CompositeID composId = CompositeID.parse(compositeId);
        Storage storage = this.service.lookForDS(composId.getDS());
        CalendarDAO dao = storage.getCalendarDAO();
        if (dao != null && (cal = (Calendar)dao.remove(composId.getId())) != null) {
            return cal;
        }
        return null;
    }

    @Override
    public Calendar newCalendarInstance(String dsId) {
        CalendarDAO dao = this.service.lookForDS(dsId).getCalendarDAO();
        if (dao != null) {
            return (Calendar)dao.newInstance();
        }
        return null;
    }
}

