/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.lock.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.lock.LockService;
import org.exoplatform.services.cms.lock.impl.LockGroupsOrUsersPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

public class LockServiceImpl
implements LockService,
Startable {
    private final String SETTING_LOCK = "SETTING_LOCK";
    private final String PRE_SETTING_LOCK = "PRE_SETTING_LOCK";
    private final String CACHE_NAME = "ecms.LockService";
    private ExoCache<String, List<String>> settingLockList;
    private List<LockGroupsOrUsersPlugin> lockGroupsOrUsersPlugin_ = new ArrayList<LockGroupsOrUsersPlugin>();
    private static final Log LOG = ExoLogger.getLogger((String)LockServiceImpl.class.getName());
    private HashMap<String, Map<String, String>> lockHolding = new HashMap();

    public LockServiceImpl(InitParams params, CacheService cacheService) throws Exception {
        this.settingLockList = cacheService.getCacheInstance("ecms.LockService");
    }

    public void addLockGroupsOrUsersPlugin(ComponentPlugin plugin) {
        if (plugin instanceof LockGroupsOrUsersPlugin) {
            this.lockGroupsOrUsersPlugin_.add((LockGroupsOrUsersPlugin)plugin);
        }
    }

    @Override
    public List<String> getPreSettingLockList() {
        return (List)this.settingLockList.get((Serializable)((Object)"PRE_SETTING_LOCK"));
    }

    @Override
    public List<String> getAllGroupsOrUsersForLock() throws Exception {
        return (List)this.settingLockList.get((Serializable)((Object)"SETTING_LOCK"));
    }

    @Override
    public void addGroupsOrUsersForLock(String groupsOrUsers) throws Exception {
        List _settingLockList = (List)this.settingLockList.get((Serializable)((Object)"SETTING_LOCK"));
        if (_settingLockList != null && !_settingLockList.contains(groupsOrUsers)) {
            _settingLockList.add(groupsOrUsers);
            this.settingLockList.put((Serializable)((Object)"SETTING_LOCK"), (Object)_settingLockList);
        }
    }

    @Override
    public void removeGroupsOrUsersForLock(String groupsOrUsers) throws Exception {
        List _settingLockList = (List)this.settingLockList.get((Serializable)((Object)"SETTING_LOCK"));
        if (_settingLockList != null && _settingLockList.contains(groupsOrUsers)) {
            _settingLockList.remove(groupsOrUsers);
            this.settingLockList.put((Serializable)((Object)"SETTING_LOCK"), (Object)_settingLockList);
        }
    }

    public void start() {
        this.lockHolding.clear();
        this.settingLockList.clearCache();
        this.removeLocks();
        ArrayList<String> _settingLockList = new ArrayList<String>();
        ArrayList<String> _preSettingLockList = new ArrayList<String>();
        for (LockGroupsOrUsersPlugin plugin : this.lockGroupsOrUsersPlugin_) {
            _settingLockList.addAll(plugin.initGroupsOrUsers());
            _preSettingLockList.addAll(plugin.initGroupsOrUsers());
        }
        this.settingLockList.put((Serializable)((Object)"SETTING_LOCK"), _settingLockList);
        this.settingLockList.put((Serializable)((Object)"PRE_SETTING_LOCK"), _preSettingLockList);
    }

    public void stop() {
        this.lockHolding.clear();
        this.settingLockList.clearCache();
    }

    @Override
    public HashMap<String, Map<String, String>> getLockHolding() {
        return this.lockHolding;
    }

    @Override
    public void putToLockHoding(String userId, Map<String, String> lockedNodesInfo) {
        this.lockHolding.put(userId, lockedNodesInfo);
    }

    @Override
    public Map<String, String> getLockInformation(String userId) {
        return this.lockHolding.get(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLocksOfUser(String userId) {
        Map<String, String> lockedNodes;
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        RepositoryService repositoryService = WCMCoreUtils.getService(RepositoryService.class);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Removing all locked nodes of user " + userId));
        }
        if ((lockedNodes = this.lockHolding.get(userId)) == null || lockedNodes.values().isEmpty()) {
            return;
        }
        try {
            Iterator<String> iter = lockedNodes.keySet().iterator();
            while (iter.hasNext()) {
                try {
                    String key = iter.next();
                    String[] temp = key.split(":/:");
                    String nodePath = temp[1];
                    String[] location = temp[0].split("/::/");
                    String workspaceName = location[1];
                    Session session = sessionProvider.getSession(workspaceName, repositoryService.getCurrentRepository());
                    String lockToken = lockedNodes.get(key);
                    session.addLockToken(lockToken);
                    Node node = null;
                    try {
                        node = (Node)session.getItem(nodePath);
                    }
                    catch (PathNotFoundException e) {
                        if (!LOG.isInfoEnabled()) continue;
                        LOG.info((Object)("Node " + nodePath + " has been already removed before"));
                        continue;
                    }
                    if (!node.isCheckedOut() && node.isNodeType("mix:versionable")) {
                        node.checkout();
                    }
                    if (node.isLocked()) {
                        node.unlock();
                    }
                    if (node.isNodeType("mix:lockable") && node.isCheckedOut()) {
                        node.removeMixin("mix:lockable");
                    }
                    node.save();
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)"Error while unlocking the locked nodes", (Throwable)e);
                }
            }
            lockedNodes.clear();
        }
        finally {
            sessionProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLocks() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Clean all locked nodes in the system");
        }
        RepositoryService repositoryService = WCMCoreUtils.getService(RepositoryService.class);
        try (SessionProvider sessionProvider = SessionProvider.createSystemProvider();){
            String wsName = repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
            Session session = sessionProvider.getSession(wsName, repositoryService.getCurrentRepository());
            String lockQueryStatement = "SELECT * from mix:lockable ORDER BY exo:dateCreated";
            QueryResult queryResult = session.getWorkspace().getQueryManager().createQuery(lockQueryStatement, "sql").execute();
            NodeIterator nodeIter = queryResult.getNodes();
            while (nodeIter.hasNext()) {
                Node lockedNode = nodeIter.nextNode();
                if (!lockedNode.isCheckedOut() && lockedNode.isNodeType("mix:versionable")) {
                    lockedNode.checkout();
                }
                if (lockedNode.isLocked()) {
                    lockedNode.unlock();
                }
                if (lockedNode.isNodeType("mix:lockable") && lockedNode.isCheckedOut()) {
                    lockedNode.removeMixin("mix:lockable");
                }
                lockedNode.save();
            }
        }
    }

    @Override
    public String getLockTokenOfUser(Node node) throws Exception {
        Map<String, String> lockedNodesInfo;
        String key = this.createLockKey(node);
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        if (userId == null) {
            userId = IdentityConstants.ANONIM;
        }
        if ((lockedNodesInfo = this.getLockInformation(userId)) != null && lockedNodesInfo.get(key) != null) {
            return lockedNodesInfo.get(key);
        }
        return null;
    }

    @Override
    public String createLockKey(Node node) throws Exception {
        StringBuffer buffer = new StringBuffer();
        Session session = node.getSession();
        String repositoryName = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        if (userId == null) {
            userId = IdentityConstants.ANONIM;
        }
        buffer.append(repositoryName).append("/::/").append(session.getWorkspace().getName()).append("/::/").append(userId).append(":/:").append(node.getPath());
        return buffer.toString();
    }

    @Override
    public String createLockKey(Node node, String userId) throws Exception {
        StringBuffer buffer = new StringBuffer();
        Session session = node.getSession();
        String repositoryName = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
        if (userId == null) {
            userId = IdentityConstants.ANONIM;
        }
        buffer.append(repositoryName).append("/::/").append(session.getWorkspace().getName()).append("/::/").append(userId).append(":/:").append(node.getPath());
        return buffer.toString();
    }

    @Override
    public String getLockToken(Node node) throws Exception {
        Map<String, String> lockedNodesInfo;
        String key = this.createLockKey(node);
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        String userId = currentIdentity.getUserId();
        if (userId == null) {
            userId = IdentityConstants.ANONIM;
        }
        if ((lockedNodesInfo = this.getLockInformation(userId)) != null && lockedNodesInfo.get(key) != null) {
            return lockedNodesInfo.get(key);
        }
        Collection collection = currentIdentity.getMemberships();
        for (MembershipEntry membership : collection) {
            StringBuffer permissionBuffer = new StringBuffer();
            permissionBuffer.append(membership.getMembershipType()).append(":").append(membership.getGroup());
            if (permissionBuffer == null || permissionBuffer.toString().length() <= 0) continue;
            String keyPermission = this.createLockKey(node, permissionBuffer.toString());
            lockedNodesInfo = this.getLockInformation(permissionBuffer.toString());
            if (lockedNodesInfo == null || lockedNodesInfo.get(keyPermission) == null) continue;
            return lockedNodesInfo.get(keyPermission);
        }
        return null;
    }

    @Override
    public void changeLockToken(String srcPath, Node newNode) throws Exception {
        Map<String, String> lockedNodesInfo;
        String newKey = this.createLockKey(newNode);
        String oldKey = this.getOldLockKey(srcPath, newNode);
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        if (userId == null) {
            userId = IdentityConstants.ANONIM;
        }
        if ((lockedNodesInfo = this.getLockInformation(userId)) == null) {
            lockedNodesInfo = new HashMap<String, String>();
        }
        if (lockedNodesInfo.containsKey(oldKey)) {
            lockedNodesInfo.put(newKey, lockedNodesInfo.get(oldKey));
            lockedNodesInfo.remove(oldKey);
        }
        this.putToLockHoding(userId, lockedNodesInfo);
    }

    @Override
    public void changeLockToken(Node oldNode, Node newNode) throws Exception {
        Map<String, String> lockedNodesInfo;
        String newKey = this.createLockKey(newNode);
        String oldKey = this.createLockKey(oldNode);
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        if (userId == null) {
            userId = IdentityConstants.ANONIM;
        }
        if ((lockedNodesInfo = this.getLockInformation(userId)) == null) {
            lockedNodesInfo = new HashMap<String, String>();
        }
        lockedNodesInfo.remove(oldKey);
        lockedNodesInfo.put(newKey, newNode.getLock().getLockToken());
        this.putToLockHoding(userId, lockedNodesInfo);
    }

    @Override
    public String getOldLockKey(String srcPath, Node node) throws Exception {
        StringBuffer buffer = new StringBuffer();
        Session session = node.getSession();
        String repositoryName = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
        buffer.append(repositoryName).append("/::/").append(session.getWorkspace().getName()).append("/::/").append(session.getUserID()).append(":/:").append(srcPath);
        return buffer.toString();
    }
}

