/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.handler;

import java.io.PrintWriter;
import java.io.Serializable;
import javax.jcr.Node;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.ecm.utils.MessageDigester;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.controller.QualifiedName;

public class SiteJavascriptHandler
extends WebRequestHandler {
    private ExoCache<String, Object> jsCache_;
    private String siteName_;
    private LivePortalManagerService livePortalManagerService_;
    public static final String CACHE_REGION = "ecms.site.javascript.cache";

    public String getHandlerName() {
        return "javascript";
    }

    public synchronized boolean execute(ControllerContext context) throws Exception {
        String key;
        String jsData;
        if (this.jsCache_ == null) {
            this.jsCache_ = WCMCoreUtils.getService(CacheService.class).getCacheInstance(CACHE_REGION);
        }
        this.siteName_ = context.getParameter(QualifiedName.create((String)"gtn", (String)"sitename"));
        String username = IdentityConstants.ANONIM;
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null && conversationState.getIdentity() != null && StringUtils.isBlank((CharSequence)(username = conversationState.getIdentity().getUserId()))) {
            username = IdentityConstants.ANONIM;
        }
        if ((jsData = (String)this.jsCache_.get((Serializable)((Object)(key = MessageDigester.getHash(this.siteName_) + MessageDigester.getHash(username))))) == null) {
            SessionProvider sessionProvider = IdentityConstants.ANONIM.equals(username) ? WCMCoreUtils.createAnonimProvider() : WCMCoreUtils.getUserSessionProvider();
            this.livePortalManagerService_ = WCMCoreUtils.getService(LivePortalManagerService.class);
            Node portalNode = null;
            portalNode = "shared".equals(this.siteName_) ? this.livePortalManagerService_.getLiveSharedPortal(sessionProvider) : this.livePortalManagerService_.getLivePortal(sessionProvider, this.siteName_);
            jsData = WCMCoreUtils.getSiteGlobalActiveJs(portalNode, sessionProvider);
            this.jsCache_.put((Serializable)((Object)key), (Object)jsData);
        }
        HttpServletResponse res = context.getResponse();
        res.setContentType("text/javascript");
        PrintWriter out = res.getWriter();
        out.println(jsData);
        return true;
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }
}

