/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.macro.children;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.mow.api.Page;
import org.exoplatform.wiki.mow.api.Wiki;
import org.exoplatform.wiki.rendering.builder.ReferenceBuilder;
import org.exoplatform.wiki.rendering.context.MarkupContextManager;
import org.exoplatform.wiki.rendering.macro.ExcerptUtils;
import org.exoplatform.wiki.rendering.macro.children.ChildrenMacroParameters;
import org.exoplatform.wiki.service.WikiContext;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.utils.TreeUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.BulletedListBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.ListItemBlock;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.listener.reference.DocumentResourceReference;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component(value="children")
public class ChildrenMacro
extends AbstractMacro<ChildrenMacroParameters> {
    private static final Log log = ExoLogger.getLogger(ChildrenMacro.class);
    private static final String DESCRIPTION = "Display children and descendants of a specific page";
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Execution execution;
    @Inject
    private MarkupContextManager markupContextManager;
    private boolean excerpt;

    public ChildrenMacro() {
        super("Children", DESCRIPTION, ChildrenMacroParameters.class);
        this.setDefaultCategory("Navigation");
    }

    public List<Block> execute(ChildrenMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        ExecutionContext ec;
        boolean descendant = parameters.isDescendant();
        this.excerpt = parameters.isExcerpt();
        String documentName = parameters.getParent();
        String childrenNum = parameters.getChildrenNum();
        String depth = parameters.getDepth();
        WikiPageParams params = this.markupContextManager.getMarkupContext(documentName, ResourceType.DOCUMENT);
        if ("".equals(documentName) && (ec = this.execution.getContext()) != null) {
            WikiContext wikiContext = (WikiContext)ec.getProperty("wikicontext");
            params = wikiContext;
        }
        try {
            WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
            Page wikiPage = wikiService.getPageOfWikiByName(params.getType(), params.getOwner(), params.getPageName());
            if (wikiPage == null && (wikiPage = wikiService.getRelatedPage(params.getType(), params.getOwner(), params.getPageName())) != null) {
                Wiki wiki = wikiService.getWikiByTypeAndOwner(wikiPage.getWikiType(), wikiPage.getWikiOwner());
                params = new WikiPageParams(wiki.getType(), wiki.getOwner(), wikiPage.getName());
            }
            Block root = this.generateTree(params, descendant, childrenNum, depth, context);
            WikiContext wikiContext = this.getWikiContext();
            wikiService.addPageLink(new WikiPageParams(wikiContext.getType(), wikiContext.getOwner(), wikiContext.getPageName()), new WikiPageParams(params.getType(), params.getOwner(), params.getPageName()));
            return Collections.singletonList(root);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private Block generateTree(WikiPageParams params, boolean descendant, String childrenNum, String depth, MacroTransformationContext context) throws Exception {
        GroupBlock block = new GroupBlock();
        HashMap<String, Object> treeContext = new HashMap<String, Object>();
        treeContext.put("showDes", descendant);
        treeContext.put("childrenNumber", childrenNum);
        treeContext.put("depth", depth);
        TreeNode node = TreeUtils.getDescendants(params, treeContext);
        this.addBlock((Block)block, node, context);
        return block;
    }

    public ListItemBlock trankformToBlock(TreeNode node, MacroTransformationContext context) throws Exception {
        String excerpts;
        WikiService wikiService = (WikiService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(WikiService.class);
        ArrayList<Object> blocks = new ArrayList<Object>();
        WikiPageParams params = TreeUtils.getPageParamsFromPath(node.getPath());
        Page page = wikiService.getPageOfWikiByName(params.getType(), params.getOwner(), params.getPageName());
        DocumentResourceReference link = new DocumentResourceReference(this.getReferenceBuilder(context).build(params));
        ArrayList<WordBlock> content = new ArrayList<WordBlock>();
        content.add(new WordBlock(page.getTitle()));
        LinkBlock linkBlock = new LinkBlock(content, (ResourceReference)link, true);
        blocks.add(linkBlock);
        if (this.excerpt && !"".equals(excerpts = ExcerptUtils.getExcerpts(params))) {
            blocks.add(new RawBlock(excerpts, Syntax.XHTML_1_0));
        }
        return new ListItemBlock(blocks);
    }

    public void addBlock(Block block, TreeNode node, MacroTransformationContext context) throws Exception {
        List<TreeNode> children = node.getChildren();
        BulletedListBlock childrenBlock = new BulletedListBlock(Collections.emptyList());
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            ListItemBlock listBlock = this.trankformToBlock(children.get(i), context);
            this.addBlock((Block)listBlock, children.get(i), context);
            childrenBlock.addChild((Block)listBlock);
        }
        block.addChild((Block)childrenBlock);
    }

    public boolean supportsInlineMode() {
        return true;
    }

    private ReferenceBuilder getReferenceBuilder(MacroTransformationContext context) throws MacroExecutionException {
        try {
            return (ReferenceBuilder)this.componentManager.getInstance(ReferenceBuilder.class, context.getSyntax().toIdString());
        }
        catch (ComponentLookupException e) {
            throw new MacroExecutionException(String.format("Failed to find reference builder for syntax %s", context.getSyntax().toIdString()), (Throwable)e);
        }
    }

    private WikiContext getWikiContext() {
        ExecutionContext ec = this.execution.getContext();
        WikiContext wikiContext = null;
        if (ec != null) {
            wikiContext = (WikiContext)ec.getProperty("wikicontext");
        }
        return wikiContext;
    }
}

