/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.apache.shindig.gadgets.oauth.OAuthCallbackStateToken;

public class OAuthCallbackState {
    private final BlobCrypter crypter;
    private OAuthCallbackStateToken state;

    public OAuthCallbackState(BlobCrypter crypter) {
        this.crypter = crypter;
        this.state = new OAuthCallbackStateToken();
    }

    public OAuthCallbackState(BlobCrypter crypter, String stateBlob) {
        this.crypter = crypter;
        Map state = null;
        if (stateBlob != null) {
            try {
                state = crypter.unwrap(stateBlob);
                if (state == null) {
                    state = Maps.newHashMap();
                }
                this.state = new OAuthCallbackStateToken(state);
                this.state.enforceNotExpired();
            }
            catch (BlobCrypterException e) {
                state = null;
            }
        }
        if (state == null) {
            this.state = new OAuthCallbackStateToken();
        }
    }

    public String getEncryptedState() throws BlobCrypterException {
        return this.crypter.wrap(this.state.toMap());
    }

    public String getRealCallbackUrl() {
        return this.state.getRealCallbackUrl();
    }

    public void setRealCallbackUrl(String realCallbackUrl) {
        this.state.setRealCallbackUrl(realCallbackUrl);
    }
}

