/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.inject.Inject;
import java.util.Collection;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.preload.PreloaderService;
import org.apache.shindig.gadgets.render.GadgetRewritersProvider;
import org.apache.shindig.gadgets.render.ProxyRenderer;
import org.apache.shindig.gadgets.render.RenderingException;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.spec.View;

public class HtmlRenderer {
    public static final String PATH_PARAM = "path";
    private final PreloaderService preloader;
    private final ProxyRenderer proxyRenderer;
    private final GadgetRewritersProvider gadgetRewritersProvider;
    private final GadgetHtmlParser htmlParser;

    @Inject
    public HtmlRenderer(PreloaderService preloader, ProxyRenderer proxyRenderer, GadgetRewritersProvider gadgetRewritersProvider, GadgetHtmlParser htmlParser) {
        this.preloader = preloader;
        this.proxyRenderer = proxyRenderer;
        this.gadgetRewritersProvider = gadgetRewritersProvider;
        this.htmlParser = htmlParser;
    }

    public String render(Gadget gadget) throws RenderingException {
        try {
            View view = gadget.getCurrentView();
            Collection<PreloadedData> preloads = this.preloader.preload(gadget);
            gadget.setPreloads(preloads);
            String content = view.getHref() == null ? this.getViewContent(gadget) : this.proxyRenderer.render(gadget);
            MutableContent mc = new MutableContent(this.htmlParser, content);
            for (GadgetRewriter rewriter : this.gadgetRewritersProvider.getRewriters(gadget.getContext())) {
                rewriter.rewrite(gadget, mc);
            }
            return mc.getContent();
        }
        catch (GadgetException e) {
            throw new RenderingException(e.getMessage(), e, e.getHttpStatusCode());
        }
        catch (RewritingException e) {
            throw new RenderingException(e.getMessage(), e, e.getHttpStatusCode());
        }
    }

    protected String getViewContent(Gadget gadget) {
        View currentView = gadget.getCurrentView();
        return currentView.getContent();
    }
}

