/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.rewrite.AbsolutePathReferenceVisitor;
import org.apache.shindig.gadgets.rewrite.DomWalker;

public class AbsolutePathReferenceRewriter
extends DomWalker.Rewriter {
    private static final Logger LOG = Logger.getLogger(AbsolutePathReferenceRewriter.class.getName());
    private AbsolutePathReferenceVisitor.Tags[] tags = new AbsolutePathReferenceVisitor.Tags[]{AbsolutePathReferenceVisitor.Tags.RESOURCES};

    @Inject
    public AbsolutePathReferenceRewriter() {
    }

    @Inject(optional=true)
    public void setAbsolutePathTags(@Named(value="shindig.gadgets.rewriter.absolutePath.tags") String absolutePathTags) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Tags that should have the reference resolved to absolute path: " + absolutePathTags);
        }
        String[] tagsArray = absolutePathTags.split(",");
        ArrayList tagsList = Lists.newArrayList();
        for (String tagValue : tagsArray) {
            try {
                AbsolutePathReferenceVisitor.Tags tag = AbsolutePathReferenceVisitor.Tags.valueOf(tagValue);
                if (tagsList.contains((Object)tag)) continue;
                tagsList.add(tag);
            }
            catch (Exception ex) {
                LOG.warning("Invalid absolute path tag name : " + tagValue);
            }
        }
        this.tags = tagsList.toArray(new AbsolutePathReferenceVisitor.Tags[tagsList.size()]);
    }

    @Override
    protected List<DomWalker.Visitor> makeVisitors(Gadget context, Uri gadgetUri) {
        return ImmutableList.of((Object)new AbsolutePathReferenceVisitor(this.tags));
    }
}

