/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseOAuthService {
    private static final String URL_ATTR = "url";
    private static final String PARAM_LOCATION_ATTR = "param_location";
    private static final String METHOD_ATTR = "method";

    BaseOAuthService() {
    }

    public BaseOAuthService(Element serviceElement, Uri base) throws SpecParserException {
    }

    public abstract String getName();

    Uri parseAuthorizationUrl(Element child, Uri base) throws SpecParserException {
        Uri url = XmlUtil.getHttpUriAttribute((Node)child, (String)URL_ATTR, (Uri)base);
        if (url == null) {
            throw new SpecParserException("OAuth/Service/Authorization @url is not valid: " + child.getAttribute(URL_ATTR));
        }
        return base.resolve(url);
    }

    EndPoint parseEndPoint(String where, Element child, Uri base) throws SpecParserException {
        Uri url = XmlUtil.getHttpUriAttribute((Node)child, (String)URL_ATTR, (Uri)base);
        if (url == null) {
            throw new SpecParserException("Not an HTTP url: " + child.getAttribute(URL_ATTR));
        }
        Location location = Location.parse(child.getAttribute(PARAM_LOCATION_ATTR));
        Method method = Method.parse(child.getAttribute(METHOD_ATTR));
        return new EndPoint(base.resolve(url), method, location);
    }

    public static class EndPoint {
        public final Uri url;
        public final Method method;
        public final Location location;

        public Uri getUrl() {
            return this.url;
        }

        public Method getMethod() {
            return this.method;
        }

        public Location getLocation() {
            return this.location;
        }

        public EndPoint(Uri url, Method method, Location location) {
            this.url = url;
            this.method = method;
            this.location = location;
        }

        public String toString(String element) {
            return '<' + element + " url='" + this.url.toString() + "' " + "method='" + (Object)((Object)this.method) + "' param_location='" + (Object)((Object)this.location) + "'/>";
        }
    }

    public static enum Location {
        HEADER("auth-header"),
        URL("uri-query"),
        BODY("post-body");

        private static final Map<String, Location> LOCATIONS;
        private String locationString;

        private Location(String locationString) {
            this.locationString = locationString;
        }

        public String toString() {
            return this.locationString;
        }

        public static Location parse(String value) throws SpecParserException {
            Location result = LOCATIONS.get(value = value.trim());
            if (result == null) {
                throw new SpecParserException("Unknown OAuth param_location: " + value);
            }
            return result;
        }

        static {
            LOCATIONS = Maps.newHashMap();
            for (Location l : Location.values()) {
                LOCATIONS.put(l.locationString, l);
            }
            LOCATIONS.put("", HEADER);
        }
    }

    public static enum Method {
        GET,
        POST;

        private static final Map<String, Method> METHODS;

        public static Method parse(String value) throws SpecParserException {
            Method result = METHODS.get(value = value.trim());
            if (result == null) {
                throw new SpecParserException("Unknown OAuth method: " + value);
            }
            return result;
        }

        static {
            METHODS = ImmutableMap.of((Object)GET.toString(), (Object)((Object)GET), (Object)POST.toString(), (Object)((Object)POST), (Object)"", (Object)((Object)GET));
        }
    }
}

