/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates.tags;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shindig.gadgets.templates.ElementELResolver;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.apache.shindig.gadgets.templates.tags.AbstractTagHandler;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TemplateBasedTagHandler
extends AbstractTagHandler {
    private final Element templateDefinition;

    public TemplateBasedTagHandler(Element templateDefinition, String namespaceUri, String tagName) {
        super(namespaceUri, tagName);
        this.templateDefinition = templateDefinition;
    }

    @Override
    public void process(Node result, Element tagInstance, TemplateProcessor processor) {
        DocumentFragment processedContent = this.processChildren(tagInstance, processor);
        Map<String, Object> oldMy = processor.getTemplateContext().setMy(this.computeMy(tagInstance, processedContent, processor));
        Object oldCur = processor.getTemplateContext().setCur(null);
        Node oldTemplateRoot = processor.getTemplateContext().setTemplateRoot(processedContent);
        this.processTemplate(result, tagInstance, processor);
        processor.getTemplateContext().setMy(oldMy);
        processor.getTemplateContext().setCur(oldCur);
        processor.getTemplateContext().setTemplateRoot(oldTemplateRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTemplate(Node result, Element tagInstance, TemplateProcessor processor) {
        Node node = result;
        synchronized (node) {
            processor.processChildNodes(result, this.templateDefinition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> computeMy(Element tagInstance, Node processedContent, TemplateProcessor processor) {
        Node clonedSource;
        HashMap myMap = Maps.newHashMap();
        Node node = processedContent;
        synchronized (node) {
            clonedSource = processedContent.cloneNode(true);
        }
        int children = clonedSource.getChildNodes().getLength();
        for (Node childNode = clonedSource.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            List<ElementELResolver.ElementWrapper> bucket;
            if (!(childNode instanceof Element)) continue;
            Element el = (Element)childNode;
            String name = el.getLocalName();
            if (name == null) {
                name = el.getNodeName();
            }
            ElementELResolver.ElementWrapper wrapper = new ElementELResolver.ElementWrapper(el);
            Object previous = myMap.get(name);
            if (previous == null) {
                myMap.put(name, wrapper);
                continue;
            }
            if (previous instanceof ElementELResolver.ElementWrapper) {
                bucket = Lists.newArrayListWithCapacity((int)children);
                bucket.add((ElementELResolver.ElementWrapper)previous);
                bucket.add(wrapper);
                myMap.put(name, bucket);
                continue;
            }
            bucket = (List)previous;
            bucket.add(wrapper);
        }
        NamedNodeMap atts = tagInstance.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            String name = atts.item(i).getNodeName();
            myMap.put(name, this.getValueFromTag(tagInstance, name, processor, Object.class));
        }
        return myMap;
    }
}

