/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.uri.ProxyUriBase;
import org.apache.shindig.gadgets.uri.UriStatus;

public interface ConcatUriManager {
    public List<ConcatData> make(List<ConcatUri> var1, boolean var2);

    public ConcatUri process(Uri var1);

    public static interface Versioner {
        public List<String> version(List<List<Uri>> var1, String var2, List<String> var3);

        public UriStatus validate(List<Uri> var1, String var2, String var3);
    }

    public static class ConcatUri
    extends ProxyUriBase {
        private final List<Uri> batch;
        private final Type type;
        private final String splitParam;

        public ConcatUri(Gadget gadget, List<Uri> batch, Type type) {
            super(gadget);
            this.batch = batch;
            this.type = type;
            this.splitParam = null;
        }

        public ConcatUri(UriStatus status, List<Uri> uris, String splitParam, Type type, Uri origUri) {
            super(status, origUri);
            this.batch = uris;
            this.splitParam = splitParam;
            this.type = type;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ConcatUri)) {
                return false;
            }
            ConcatUri objUri = (ConcatUri)obj;
            return super.equals(obj) && Objects.equal(this.batch, objUri.batch) && Objects.equal((Object)this.splitParam, (Object)objUri.splitParam) && Objects.equal((Object)((Object)this.type), (Object)((Object)objUri.type));
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.batch, this.splitParam, this.type});
        }

        public List<Uri> getBatch() {
            return this.batch;
        }

        public Type getType() {
            return this.type;
        }

        public String getSplitParam() {
            return this.splitParam;
        }

        public static List<ConcatUri> fromList(Gadget gadget, List<List<Uri>> batches, Type type) {
            ArrayList ctx = Lists.newArrayListWithCapacity((int)batches.size());
            for (List<Uri> batch : batches) {
                ctx.add(new ConcatUri(gadget, batch, type));
            }
            return ctx;
        }
    }

    public static class ConcatData {
        private final List<Uri> uris;
        private final Map<Uri, String> snippets;

        public ConcatData(List<Uri> uris, Map<Uri, String> snippets) {
            this.uris = Collections.unmodifiableList(uris);
            this.snippets = snippets;
        }

        public List<Uri> getUris() {
            return this.uris;
        }

        public String getSnippet(Uri orig) {
            return this.snippets == null || !this.snippets.containsKey(orig) ? null : this.snippets.get(orig);
        }
    }

    public static enum Type {
        JS("text/javascript", "src", "js", "script"),
        CSS("text/css", "href", "css", "link");

        private final String mimeType;
        private final String srcAttrib;
        private final String type;
        private final String tagName;

        private Type(String mimeType, String srcAttrib, String type, String tagName) {
            this.mimeType = mimeType;
            this.srcAttrib = srcAttrib;
            this.type = type;
            this.tagName = tagName;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getSrcAttrib() {
            return this.srcAttrib;
        }

        public String getType() {
            return this.type;
        }

        public String getTagName() {
            return this.tagName;
        }

        public static Type fromType(String type) {
            for (Type val : Type.values()) {
                if (!val.getType().equalsIgnoreCase(type)) continue;
                return val;
            }
            return null;
        }

        public static Type fromMime(String mime) {
            for (Type val : Type.values()) {
                if (!val.getMimeType().equals(mime)) continue;
                return val;
            }
            return null;
        }
    }
}

