/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shindig.common.Nullable;
import org.apache.shindig.common.servlet.Authority;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.uri.ConcatUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.apache.shindig.gadgets.uri.UriStatus;

public class DefaultConcatUriManager
implements ConcatUriManager {
    public static final String CONCAT_HOST_PARAM = "gadgets.uri.concat.host";
    public static final String CONCAT_PATH_PARAM = "gadgets.uri.concat.path";
    public static final String CONCAT_JS_SPLIT_PARAM = "gadgets.uri.concat.js.splitToken";
    public static final String CONCAT_JS_EVAL_TPL = "eval(%s['%s']);";
    private static final ConcatUriManager.ConcatUri BAD_URI = new ConcatUriManager.ConcatUri(UriStatus.BAD_URI, null, null, null, null);
    private static final Integer START_INDEX = 1;
    private final ContainerConfig config;
    private final ConcatUriManager.Versioner versioner;
    private boolean strictParsing;
    private Authority authority;
    private static int DEFAULT_URL_MAX_LENGTH = 2048;
    private int urlMaxLength = DEFAULT_URL_MAX_LENGTH;
    private static final float URL_LENGTH_BUFFER_MARGIN = 0.8f;

    @Inject
    public DefaultConcatUriManager(ContainerConfig config, @Nullable ConcatUriManager.Versioner versioner) {
        this.config = config;
        this.versioner = versioner;
    }

    @Inject(optional=true)
    public void setUseStrictParsing(@Named(value="shindig.uri.concat.use-strict-parsing") boolean useStrict) {
        this.strictParsing = useStrict;
    }

    @Inject(optional=true)
    public void setUrlMaxLength(@Named(value="org.apache.shindig.gadgets.uri.urlMaxLength") int urlMaxLength) {
        this.urlMaxLength = urlMaxLength;
    }

    @Inject(optional=true)
    public void setAuthority(Authority authority) {
        this.authority = authority;
    }

    public int getUrlMaxLength() {
        return this.urlMaxLength;
    }

    @Override
    public List<ConcatUriManager.ConcatData> make(List<ConcatUriManager.ConcatUri> resourceUris, boolean isAdjacent) {
        ArrayList concatUris = Lists.newArrayListWithCapacity((int)resourceUris.size());
        if (resourceUris.isEmpty()) {
            return concatUris;
        }
        ConcatUriManager.ConcatUri exemplar = resourceUris.get(0);
        String container = exemplar.getContainer();
        for (ConcatUriManager.ConcatUri ctx : resourceUris) {
            concatUris.add(this.makeConcatUri(ctx, isAdjacent, container));
        }
        return concatUris;
    }

    private ConcatUriManager.ConcatData makeConcatUri(ConcatUriManager.ConcatUri ctx, boolean isAdjacent, String container) {
        if (!isAdjacent && ctx.getType() != ConcatUriManager.Type.JS) {
            throw new UnsupportedOperationException("Split concatenation only supported for JS");
        }
        String concatHost = this.getReqVal(ctx.getContainer(), CONCAT_HOST_PARAM);
        String concatPath = this.getReqVal(ctx.getContainer(), CONCAT_PATH_PARAM);
        List<Uri> resourceUris = ctx.getBatch();
        Map<Object, Object> snippets = Maps.newHashMapWithExpectedSize((int)resourceUris.size());
        String splitParam = this.config.getString(ctx.getContainer(), CONCAT_JS_SPLIT_PARAM);
        boolean doSplit = false;
        if (!isAdjacent && splitParam != null && !"false".equalsIgnoreCase(splitParam)) {
            doSplit = true;
        }
        UriBuilder uriBuilder = this.makeUriBuilder(ctx, concatHost, concatPath);
        int injectedMaxUrlLength = (int)((float)this.getUrlMaxLength() * 0.8f);
        ArrayList batchUris = Lists.newArrayList();
        ArrayList uris = Lists.newArrayList();
        Integer i = START_INDEX;
        for (Uri resource : resourceUris) {
            uriBuilder.addQueryParameter(i.toString(), resource.toString());
            if (uriBuilder.toString().length() > injectedMaxUrlLength) {
                uriBuilder.removeQueryParameter(i.toString());
                this.addVersionAndSplitParam(uriBuilder, splitParam, doSplit, batchUris, container, ctx.getType());
                uris.add(uriBuilder.toUri());
                uriBuilder = this.makeUriBuilder(ctx, concatHost, concatPath);
                batchUris = Lists.newArrayList();
                i = START_INDEX;
                uriBuilder.addQueryParameter(i.toString(), resource.toString());
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
            batchUris.add(resource);
        }
        if (batchUris != null && uriBuilder != ctx.makeQueryParams(null, null)) {
            this.addVersionAndSplitParam(uriBuilder, splitParam, doSplit, batchUris, container, ctx.getType());
            uris.add(uriBuilder.toUri());
        }
        if (doSplit) {
            snippets = this.createSnippets(uris);
        }
        return new ConcatUriManager.ConcatData(uris, snippets);
    }

    private void addVersionAndSplitParam(UriBuilder uriBuilder, String splitParam, boolean doSplit, List<Uri> batchUris, String container, ConcatUriManager.Type type) {
        int hashCode = uriBuilder.hashCode();
        if (doSplit) {
            uriBuilder.addQueryParameter(UriCommon.Param.JSON.getKey(), splitParam + String.valueOf(Math.abs(hashCode)));
        }
        if (this.versioner != null) {
            String version;
            ArrayList batches = Lists.newArrayList();
            ArrayList resourceTags = Lists.newArrayList();
            batches.add(batchUris);
            resourceTags.add(type.getTagName().toLowerCase());
            List<String> versions = this.versioner.version(batches, container, resourceTags);
            if (versions != null && versions.size() == 1 && (version = versions.get(0)) != null) {
                uriBuilder.addQueryParameter(UriCommon.Param.VERSION.getKey(), version);
            }
        }
    }

    private Map<Uri, String> createSnippets(List<Uri> uris) {
        HashMap snippets = Maps.newHashMap();
        for (Uri uri : uris) {
            String resourceUri;
            Integer i = START_INDEX;
            String splitParam = uri.getQueryParameter(UriCommon.Param.JSON.getKey());
            while ((resourceUri = uri.getQueryParameter(i.toString())) != null) {
                Uri resource = Uri.parse((String)resourceUri);
                snippets.put(resource, DefaultConcatUriManager.getJsSnippet(splitParam, resource));
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        return snippets;
    }

    private UriBuilder makeUriBuilder(ConcatUriManager.ConcatUri ctx, String authority, String path) {
        UriBuilder uriBuilder = ctx.makeQueryParams(null, null);
        uriBuilder.setAuthority(authority);
        uriBuilder.setPath(path);
        uriBuilder.addQueryParameter(UriCommon.Param.TYPE.getKey(), ctx.getType().getType());
        return uriBuilder;
    }

    static String getJsSnippet(String splitParam, Uri resource) {
        return String.format(CONCAT_JS_EVAL_TPL, splitParam, StringEscapeUtils.escapeEcmaScript((String)resource.toString()));
    }

    private String getReqVal(String container, String key) {
        String val = this.config.getString(container, key);
        if (val == null) {
            throw new RuntimeException("Missing required config '" + key + "' for container: " + container);
        }
        if (this.authority != null) {
            val = val.replace("%authority%", this.authority.getAuthority());
        }
        return val;
    }

    @Override
    public ConcatUriManager.ConcatUri process(Uri uri) {
        String version;
        String uriStr;
        String container = uri.getQueryParameter(UriCommon.Param.CONTAINER.getKey());
        if (this.strictParsing && container == null) {
            return BAD_URI;
        }
        if (this.strictParsing) {
            String concatHost = this.getReqVal(container, CONCAT_HOST_PARAM);
            String concatPath = this.getReqVal(container, CONCAT_PATH_PARAM);
            if (!uri.getAuthority().equalsIgnoreCase(concatHost) || !uri.getPath().equals(concatPath)) {
                return BAD_URI;
            }
        }
        UriStatus status = UriStatus.VALID_UNVERSIONED;
        LinkedList uris = Lists.newLinkedList();
        ConcatUriManager.Type type = ConcatUriManager.Type.fromType(uri.getQueryParameter(UriCommon.Param.TYPE.getKey()));
        if (type == null && (type = ConcatUriManager.Type.fromMime(uri.getQueryParameter("rewriteMime"))) == null) {
            return BAD_URI;
        }
        String splitParam = type == ConcatUriManager.Type.JS ? uri.getQueryParameter(UriCommon.Param.JSON.getKey()) : null;
        Integer i = START_INDEX;
        while ((uriStr = uri.getQueryParameter(i.toString())) != null) {
            try {
                Uri concatUri = Uri.parse((String)uriStr);
                if (concatUri.getScheme() == null) {
                    concatUri = new UriBuilder(concatUri).setScheme(uri.getScheme()).toUri();
                }
                uris.add(concatUri);
            }
            catch (IllegalArgumentException e) {
                return BAD_URI;
            }
            Integer e = i;
            Integer n = i = Integer.valueOf(i + 1);
        }
        if (this.versioner != null && (version = uri.getQueryParameter(UriCommon.Param.VERSION.getKey())) != null) {
            status = this.versioner.validate(uris, container, version);
        }
        return new ConcatUriManager.ConcatUri(status, uris, splitParam, type, uri);
    }
}

