/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.JsCompileMode;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.uri.ProxyUriBase;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.apache.shindig.gadgets.uri.UriStatus;

public interface JsUriManager {
    public Uri makeExternJsUri(JsUri var1);

    public JsUri processExternJsUri(Uri var1) throws GadgetException;

    public static interface Versioner {
        public String version(JsUri var1);

        public UriStatus validate(JsUri var1, String var2);
    }

    public static class JsUri
    extends ProxyUriBase {
        private static final Collection<String> EMPTY_COLL = Collections.emptyList();
        private final Collection<String> libs;
        private final Collection<String> loadedLibs;
        private final String onload;
        private final RenderingContext context;
        private final Uri origUri;
        private JsCompileMode compileMode;
        private boolean jsload;
        private boolean nohint;
        private String repository;

        public JsUri(UriStatus status, Uri origUri, Collection<String> libs, Collection<String> have) {
            super(status, origUri);
            if (origUri != null) {
                String contextParam = origUri.getQueryParameter(UriCommon.Param.CONTAINER_MODE.getKey());
                this.context = RenderingContext.valueOfParam(contextParam);
                String compileParam = origUri.getQueryParameter(UriCommon.Param.COMPILE_MODE.getKey());
                this.compileMode = JsCompileMode.valueOfParam(compileParam);
                this.jsload = "1".equals(origUri.getQueryParameter(UriCommon.Param.JSLOAD.getKey()));
                this.onload = origUri.getQueryParameter(UriCommon.Param.ONLOAD.getKey());
                this.nohint = "1".equals(origUri.getQueryParameter(UriCommon.Param.NO_HINT.getKey()));
                this.repository = origUri.getQueryParameter(UriCommon.Param.REPOSITORY_ID.getKey());
            } else {
                this.context = RenderingContext.getDefault();
                this.compileMode = JsCompileMode.getDefault();
                this.jsload = false;
                this.onload = null;
                this.nohint = false;
                this.repository = null;
            }
            this.libs = this.nonNullLibs(libs);
            this.loadedLibs = this.nonNullLibs(have);
            this.origUri = origUri;
        }

        public JsUri(UriStatus status) {
            this(status, null, EMPTY_COLL, EMPTY_COLL);
        }

        public JsUri(UriStatus status, Collection<String> libs, RenderingContext context, String onload, boolean jsload, boolean nohint, String repository) {
            super(status, null);
            this.compileMode = JsCompileMode.getDefault();
            this.onload = onload;
            this.jsload = jsload;
            this.nohint = nohint;
            this.context = context;
            this.libs = this.nonNullLibs(libs);
            this.loadedLibs = EMPTY_COLL;
            this.origUri = null;
            this.repository = repository;
        }

        public JsUri(Gadget gadget, Collection<String> libs) {
            super(gadget);
            this.compileMode = JsCompileMode.getDefault();
            this.onload = null;
            this.jsload = false;
            this.nohint = false;
            this.context = RenderingContext.getDefault();
            this.libs = this.nonNullLibs(libs);
            this.loadedLibs = EMPTY_COLL;
            this.origUri = null;
            this.setCajoleContent(gadget.requiresCaja());
        }

        public JsUri(Integer refresh, boolean debug, boolean noCache, String container, String gadget, Collection<String> libs, Collection<String> loadedLibs, String onload, boolean jsload, boolean nohint, RenderingContext context, Uri origUri, String repository) {
            super(null, refresh, debug, noCache, container, gadget);
            this.compileMode = JsCompileMode.getDefault();
            this.onload = onload;
            this.jsload = jsload;
            this.nohint = nohint;
            this.context = context;
            this.libs = this.nonNullLibs(libs);
            this.loadedLibs = this.nonNullLibs(loadedLibs);
            this.origUri = origUri;
            this.repository = repository;
        }

        public JsUri(JsUri origJsUri) {
            this(origJsUri.getStatus(), origJsUri);
        }

        public JsUri(UriStatus status, JsUri origJsUri) {
            super(status, origJsUri.getRefresh(), origJsUri.isDebug(), origJsUri.isNoCache(), origJsUri.getContainer(), origJsUri.getGadget());
            this.setCajoleContent(origJsUri.cajoleContent());
            this.libs = origJsUri.getLibs();
            this.loadedLibs = origJsUri.getLoadedLibs();
            this.onload = origJsUri.getOnload();
            this.jsload = origJsUri.isJsload();
            this.nohint = origJsUri.isNohint();
            this.compileMode = origJsUri.getCompileMode();
            this.context = origJsUri.getContext();
            this.origUri = origJsUri.getOrigUri();
            this.repository = origJsUri.getRepository();
            this.extensionParams = origJsUri.getExtensionParams();
        }

        public Collection<String> getLibs() {
            return this.libs;
        }

        public Collection<String> getLoadedLibs() {
            return this.loadedLibs;
        }

        private Collection<String> nonNullLibs(Collection<String> in) {
            return in != null ? Collections.unmodifiableList(Lists.newArrayList(in)) : EMPTY_COLL;
        }

        public RenderingContext getContext() {
            return this.context;
        }

        public JsCompileMode getCompileMode() {
            return this.compileMode;
        }

        public void setCompileMode(JsCompileMode mode) {
            this.compileMode = mode;
        }

        public String getOnload() {
            return this.onload;
        }

        public boolean isJsload() {
            return this.jsload;
        }

        public void setJsload(boolean jsload) {
            this.jsload = jsload;
        }

        public boolean isNohint() {
            return this.nohint;
        }

        public void setNohint(boolean nohint) {
            this.nohint = nohint;
        }

        public Uri getOrigUri() {
            return this.origUri;
        }

        public void setRepository(String repository) {
            this.repository = repository;
        }

        public String getRepository() {
            return this.repository;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof JsUri)) {
                return false;
            }
            JsUri objUri = (JsUri)obj;
            return super.equals(obj) && Objects.equal(this.libs, objUri.libs) && Objects.equal(this.loadedLibs, objUri.loadedLibs) && Objects.equal((Object)this.onload, (Object)objUri.onload) && Objects.equal((Object)this.jsload, (Object)objUri.jsload) && Objects.equal((Object)this.nohint, (Object)objUri.nohint) && Objects.equal((Object)((Object)this.compileMode), (Object)((Object)objUri.compileMode)) && Objects.equal((Object)((Object)this.context), (Object)((Object)objUri.context)) && Objects.equal((Object)this.origUri, (Object)objUri.origUri) && Objects.equal((Object)this.repository, (Object)objUri.repository);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.libs, this.loadedLibs, this.onload, this.jsload, this.nohint, this.context, this.origUri, this.compileMode, this.repository});
        }
    }
}

