/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.config.tasks;

import org.exoplatform.portal.config.NoSuchDataException;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.cache.CacheableDataTask;
import org.exoplatform.portal.pom.config.cache.DataAccessMode;
import org.exoplatform.portal.pom.data.Mapper;
import org.exoplatform.portal.pom.data.PortalData;
import org.exoplatform.portal.pom.data.PortalKey;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Page;
import org.gatein.mop.api.workspace.Site;
import org.gatein.mop.api.workspace.Workspace;

public abstract class PortalConfigTask {
    protected final PortalKey key;
    protected final ObjectType<? extends Site> type;

    protected PortalConfigTask(PortalKey key) {
        this.key = key;
        this.type = Mapper.parseSiteType(key.getType());
    }

    public static class Load
    extends PortalConfigTask
    implements CacheableDataTask<PortalKey, PortalData> {
        private PortalData config;

        public Load(PortalKey key) {
            super(key);
        }

        @Override
        public DataAccessMode getAccessMode() {
            return DataAccessMode.READ;
        }

        @Override
        public PortalKey getKey() {
            return this.key;
        }

        @Override
        public Class<PortalData> getValueType() {
            return PortalData.class;
        }

        @Override
        public PortalData run(POMSession session) {
            Workspace workspace = session.getWorkspace();
            Site site = workspace.getSite(this.type, this.key.getId());
            if (site != null) {
                return new Mapper(session).load(site);
            }
            return null;
        }

        public String toString() {
            return "PortalConfig.Load[ownerType=" + this.key.getType() + ",ownerId=" + this.key.getId() + "]";
        }
    }

    public static class Save
    extends PortalConfigTask
    implements CacheableDataTask<PortalKey, Void> {
        private final PortalData config;
        private boolean overwrite;

        public Save(PortalData config, boolean overwrite) {
            super(config.getKey());
            this.config = config;
            this.overwrite = overwrite;
        }

        @Override
        public DataAccessMode getAccessMode() {
            return this.overwrite ? DataAccessMode.WRITE : DataAccessMode.CREATE;
        }

        @Override
        public Class<Void> getValueType() {
            return Void.class;
        }

        @Override
        public PortalKey getKey() {
            return this.key;
        }

        @Override
        public Void run(POMSession session) {
            Workspace workspace = session.getWorkspace();
            Site site = workspace.getSite(this.type, this.key.getId());
            if (site != null) {
                if (!this.overwrite) {
                    throw new IllegalArgumentException("Cannot create portal " + this.config.getName() + " that already exist");
                }
            } else {
                if (this.overwrite) {
                    throw new IllegalArgumentException("Cannot update portal " + this.config.getName() + " that does not exist");
                }
                site = workspace.addSite(this.type, this.config.getName());
                Page root = site.getRootPage();
                root.addChild("pages");
                root.addChild("templates");
            }
            new Mapper(session).save(this.config, site);
            return null;
        }

        public String toString() {
            return "PortalConfig.Save[ownerType=" + this.key.getType() + ",ownerId=" + this.key.getId() + "]";
        }
    }

    public static class Remove
    extends PortalConfigTask
    implements CacheableDataTask<PortalKey, Void> {
        public Remove(PortalKey key) {
            super(key);
        }

        @Override
        public DataAccessMode getAccessMode() {
            return DataAccessMode.DESTROY;
        }

        @Override
        public Class<Void> getValueType() {
            return Void.class;
        }

        @Override
        public PortalKey getKey() {
            return this.key;
        }

        @Override
        public Void run(POMSession session) {
            Workspace workspace = session.getWorkspace();
            Site site = workspace.getSite(this.type, this.key.getId());
            if (site == null) {
                throw new NoSuchDataException("Could not remove non existing portal " + this.key.getId());
            }
            site.destroy();
            return null;
        }

        public String toString() {
            return "PortalConfig.Remove[ownerType=" + this.key.getType() + ",ownerId=" + this.key.getId() + "]";
        }
    }
}

