/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.ReleaseableIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;

public class RefCountingIndexReader
extends FilterIndexReader
implements ReleaseableIndexReader {
    private int refCount = 1;

    public RefCountingIndexReader(IndexReader in) {
        super(in);
    }

    final synchronized void acquire() {
        ++this.refCount;
    }

    public synchronized int getRefCounter() {
        return this.refCount;
    }

    @Override
    public final synchronized void release() throws IOException {
        if (--this.refCount == 0) {
            this.close();
        }
    }

    protected void doClose() throws IOException {
        Util.closeOrRelease(this.in);
    }
}

