/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.updater;

import java.lang.reflect.Field;
import java.util.concurrent.CountDownLatch;
import org.exoplatform.commons.api.persistence.DataInitializer;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.file.services.NameSpaceService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.chromattic.entity.ProviderRootEntity;
import org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl;
import org.exoplatform.social.core.jpa.updater.ActivityMigrationService;
import org.exoplatform.social.core.jpa.updater.IdentityMigrationService;
import org.exoplatform.social.core.jpa.updater.MigrationContext;
import org.exoplatform.social.core.jpa.updater.MigrationIdentityStorage;
import org.exoplatform.social.core.jpa.updater.RelationshipMigrationService;
import org.exoplatform.social.core.jpa.updater.SpaceMigrationService;
import org.exoplatform.social.core.manager.IdentityManagerImpl;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.impl.IdentityStorageImpl;
import org.picocontainer.Startable;

public class RDBMSMigrationManager
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(RDBMSMigrationManager.class);
    public static final String MIGRATION_SETTING_GLOBAL_KEY = "MIGRATION_SETTING_GLOBAL";
    public static final String MIGRATION_RUNNING_NODE_KEY = "NODE_RUNNING_MIGRATION";
    private Thread migrationThread;
    private final CountDownLatch migrater;
    private final RepositoryService repositoryService;
    private final ChromatticManager chromatticManager;
    private RelationshipMigrationService relationshipMigration;
    private ActivityMigrationService activityMigration;
    private SpaceMigrationService spaceMigration;
    private IdentityMigrationService identityMigration;
    private SettingService settingService;
    private boolean forceRemoveJCR = false;
    private boolean clusterMode = false;
    private String nodeName = null;

    public RDBMSMigrationManager(InitParams initParams, NameSpaceService nameSpaceService, RepositoryService repoService, ChromatticManager chromatticManager) {
        CommonsUtils.getService(DataInitializer.class);
        this.repositoryService = repoService;
        this.chromatticManager = chromatticManager;
        this.migrater = new CountDownLatch(1);
        if (initParams != null) {
            ValueParam param = initParams.getValueParam("forceDeleteJCRData");
            if (param != null) {
                this.forceRemoveJCR = "true".equalsIgnoreCase(param.getValue());
            }
            if ((param = initParams.getValueParam("clusterMode")) != null) {
                this.clusterMode = "true".equalsIgnoreCase(param.getValue());
            }
            if ((param = initParams.getValueParam("nodeName")) != null) {
                this.nodeName = param.getValue();
            }
        }
    }

    public RelationshipMigrationService getRelationshipMigration() {
        return this.relationshipMigration == null ? (RelationshipMigrationService)((Object)CommonsUtils.getService(RelationshipMigrationService.class)) : this.relationshipMigration;
    }

    public IdentityMigrationService getIdentityMigrationService() {
        if (this.identityMigration == null) {
            this.identityMigration = (IdentityMigrationService)((Object)CommonsUtils.getService(IdentityMigrationService.class));
        }
        return this.identityMigration;
    }

    public SpaceMigrationService getSpaceMigrationService() {
        if (this.spaceMigration == null) {
            this.spaceMigration = (SpaceMigrationService)((Object)CommonsUtils.getService(SpaceMigrationService.class));
        }
        return this.spaceMigration;
    }

    public void start() {
        this.initMigrationSetting();
        Runnable migrateTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Field field;
                long startTime;
                long timeToCleanupSpaces;
                long timeToCleanupIdentities;
                long timeToCleanupActivities;
                long timeToCleanupConnections;
                long timeToMigrateConnections;
                long timeToMigrateActivities;
                long timeToMigrateIdentities;
                long timeToMigrateSpaces;
                boolean start;
                block68: {
                    start = RDBMSMigrationManager.this.checkCanStartMigration();
                    if (!start || MigrationContext.isDone()) {
                        return;
                    }
                    try {
                        ProviderRootEntity providerRoot = RDBMSMigrationManager.this.getRelationshipMigration().getProviderRoot();
                        if (providerRoot == null || providerRoot != null && providerRoot.getProviders().get("space") == null && providerRoot.getProviders().get("organization") == null) {
                            LOG.info((Object)"No Social data to migrate from JCR to RDBMS ");
                            RDBMSMigrationManager.this.updateMigrationSettings(start);
                            RDBMSMigrationManager.this.migrater.countDown();
                            return;
                        }
                    }
                    catch (Exception ex) {
                        LOG.info((Object)"no JCR data, stopping JCR to RDBMS migration");
                        RDBMSMigrationManager.this.updateMigrationSettings(start);
                        RDBMSMigrationManager.this.migrater.countDown();
                        return;
                    }
                    timeToMigrateSpaces = 0L;
                    timeToMigrateIdentities = 0L;
                    timeToMigrateActivities = 0L;
                    timeToMigrateConnections = 0L;
                    long totalCleanupTime = 0L;
                    timeToCleanupConnections = 0L;
                    timeToCleanupActivities = 0L;
                    timeToCleanupIdentities = 0L;
                    timeToCleanupSpaces = 0L;
                    startTime = System.currentTimeMillis();
                    field = null;
                    try {
                        field = SessionImpl.class.getDeclaredField("FORCE_USE_GET_NODES_LAZILY");
                        if (field != null) {
                            field.setAccessible(true);
                            field.set(null, true);
                        }
                        if (MigrationContext.isDone()) break block68;
                        boolean useMigrationIdentityStorage = false;
                        IdentityManagerImpl identityManager = (IdentityManagerImpl)CommonsUtils.getService(IdentityManagerImpl.class);
                        IdentityStorage identityStorage = identityManager.getIdentityStorage();
                        if (!MigrationContext.isIdentityDone()) {
                            IdentityStorageImpl jcrIdentityStorage = (IdentityStorageImpl)CommonsUtils.getService(IdentityStorageImpl.class);
                            RDBMSIdentityStorageImpl jpaIdentityStorage = (RDBMSIdentityStorageImpl)CommonsUtils.getService(RDBMSIdentityStorageImpl.class);
                            MigrationIdentityStorage storage = new MigrationIdentityStorage(jcrIdentityStorage, jpaIdentityStorage, RDBMSMigrationManager.this.getIdentityMigrationService());
                            identityManager.setIdentityStorage((IdentityStorage)storage);
                            useMigrationIdentityStorage = true;
                        }
                        LOG.info((Object)"START ASYNC MIGRATION---------------------------------------------------");
                        if (!MigrationContext.isDone()) {
                            if (!MigrationContext.isDone() && !MigrationContext.isSpaceDone()) {
                                long t = System.currentTimeMillis();
                                RDBMSMigrationManager.this.getSpaceMigrationService().start();
                                RDBMSMigrationManager.this.updateSettingValue("SOC_RDBMS_SPACE_MIGRATION_DONE", MigrationContext.isSpaceDone());
                                timeToMigrateSpaces = System.currentTimeMillis() - t;
                            }
                            if (!MigrationContext.isDone() && !MigrationContext.isIdentityDone()) {
                                long t = System.currentTimeMillis();
                                RDBMSMigrationManager.this.getIdentityMigrationService().start();
                                RDBMSMigrationManager.this.updateSettingValue("SOC_RDBMS_IDENTITY_MIGRATION_DONE", MigrationContext.isIdentityDone());
                                if (useMigrationIdentityStorage && MigrationContext.isIdentityDone()) {
                                    identityManager.setIdentityStorage(identityStorage);
                                }
                                timeToMigrateIdentities = System.currentTimeMillis() - t;
                            }
                            if (!MigrationContext.isDone() && MigrationContext.isIdentityDone() && !MigrationContext.isActivityDone()) {
                                long t = System.currentTimeMillis();
                                RDBMSMigrationManager.this.getActivityMigrationService().start();
                                RDBMSMigrationManager.this.updateSettingValue("SOC_RDBMS_ACTIVITY_MIGRATION_DONE", MigrationContext.isActivityDone());
                                timeToMigrateActivities = System.currentTimeMillis() - t;
                            }
                            if (!MigrationContext.isDone() && MigrationContext.isIdentityDone() && !MigrationContext.isConnectionDone()) {
                                long t = System.currentTimeMillis();
                                RDBMSMigrationManager.this.getRelationshipMigration().start();
                                RDBMSMigrationManager.this.updateSettingValue("SOC_RDBMS_CONNECTION_MIGRATION_DONE", MigrationContext.isConnectionDone());
                                timeToMigrateConnections = System.currentTimeMillis() - t;
                            }
                        }
                        if (!MigrationContext.isDone() && MigrationContext.isIdentityDone()) {
                            if (!MigrationContext.isConnectionCleanupDone()) {
                                long t = System.currentTimeMillis();
                                RDBMSMigrationManager.this.getRelationshipMigration().doRemove();
                                if (MigrationContext.getIdentitiesCleanupConnectionFailed().isEmpty()) {
                                    RDBMSMigrationManager.this.updateSettingValue("SOC_RDBMS_CONNECTION_CLEANUP_DONE", Boolean.TRUE);
                                    MigrationContext.setConnectionCleanupDone(true);
                                }
                                timeToCleanupConnections = System.currentTimeMillis() - t;
                            }
                            if (!MigrationContext.isActivityCleanupDone()) {
                                long t = System.currentTimeMillis();
                                RDBMSMigrationManager.this.getActivityMigrationService().doRemove();
                                if (MigrationContext.getIdentitiesCleanupActivityFailed().isEmpty()) {
                                    RDBMSMigrationManager.this.updateSettingValue("SOC_RDBMS_ACTIVITY_CLEANUP_DONE", Boolean.TRUE);
                                    MigrationContext.setActivityCleanupDone(true);
                                }
                                timeToCleanupActivities = System.currentTimeMillis() - t;
                            }
                            if (!MigrationContext.isIdentityCleanupDone()) {
                                long t = System.currentTimeMillis();
                                RDBMSMigrationManager.this.getIdentityMigrationService().doRemove();
                                if (MigrationContext.getIdentitiesCleanupFailed().isEmpty()) {
                                    RDBMSMigrationManager.this.updateSettingValue("SOC_RDBMS_IDENTITY_CLEANUP_DONE", Boolean.TRUE);
                                    MigrationContext.setIdentityCleanupDone(true);
                                }
                                timeToCleanupIdentities = System.currentTimeMillis() - t;
                            }
                            if (!MigrationContext.isSpaceCleanupDone()) {
                                long t = System.currentTimeMillis();
                                RDBMSMigrationManager.this.getSpaceMigrationService().doRemove();
                                if (MigrationContext.getSpaceCleanupFailed().isEmpty()) {
                                    RDBMSMigrationManager.this.updateSettingValue("SOC_RDBMS_SPACE_CLEANUP_DONE", Boolean.TRUE);
                                    MigrationContext.setSpaceCleanupDone(true);
                                }
                                timeToCleanupSpaces = System.currentTimeMillis() - t;
                            }
                            if (MigrationContext.isIdentityCleanupDone() && MigrationContext.isSpaceCleanupDone() || RDBMSMigrationManager.this.forceRemoveJCR) {
                                RDBMSMigrationManager.this.updateSettingValue("SOC_RDBMS_MIGRATION_DONE", Boolean.TRUE);
                                MigrationContext.setDone(true);
                            }
                        }
                        LOG.info((Object)"END ASYNC MIGRATION-----------------------------------------------------");
                    }
                    catch (Exception e) {
                        try {
                            LOG.error((Object)"Failed to running Migration data from JCR to RDBMS", (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            RDBMSMigrationManager.this.removeRunningNodeIfPresent(start);
                            if (field != null) {
                                try {
                                    field.set(null, false);
                                }
                                catch (IllegalArgumentException e2) {
                                    LOG.warn((Object)e2.getMessage(), (Throwable)e2);
                                }
                                catch (IllegalAccessException e3) {
                                    LOG.warn((Object)e3.getMessage(), (Throwable)e3);
                                }
                            }
                            LOG.info((Object)String.format("Migration job has done, total time is %s (ms)", System.currentTimeMillis() - startTime));
                            LOG.info((Object)String.format("Migration space in %s (ms)", timeToMigrateSpaces));
                            LOG.info((Object)String.format("- Number space failed: %s", MigrationContext.getSpaceMigrateFailed().size()));
                            if (!MigrationContext.getSpaceMigrateFailed().isEmpty()) {
                                LOG.warn((Object)("- space failed: " + MigrationContext.getSpaceMigrateFailed()));
                            }
                            LOG.info((Object)String.format("Migration identities in %s (ms)", timeToMigrateIdentities));
                            LOG.info((Object)String.format("- Number identities failed: %s", MigrationContext.getIdentitiesMigrateFailed().size()));
                            if (!MigrationContext.getIdentitiesMigrateFailed().isEmpty()) {
                                LOG.warn((Object)("- identities failed: " + MigrationContext.getIdentitiesMigrateFailed()));
                            }
                            if (!MigrationContext.getIdentitiesMigrateFailed().isEmpty()) {
                                LOG.info((Object)"We could not continue migration job because the identities migration was failed");
                            } else {
                                LOG.info((Object)String.format("Migration relationships in %s (ms)", timeToMigrateConnections));
                                LOG.info((Object)String.format("- migrate failed for %s user(s)", MigrationContext.getIdentitiesMigrateConnectionFailed().size()));
                                if (!MigrationContext.getIdentitiesMigrateConnectionFailed().isEmpty()) {
                                    LOG.warn((Object)("- identities failed: " + MigrationContext.getIdentitiesMigrateConnectionFailed()));
                                }
                                LOG.info((Object)String.format("Migration activities in %s (ms)", timeToMigrateActivities));
                                LOG.info((Object)String.format("- migrate failed for %s user(s)", MigrationContext.getIdentitiesMigrateActivityFailed().size()));
                                if (!MigrationContext.getIdentitiesMigrateActivityFailed().isEmpty()) {
                                    LOG.warn((Object)("- identities failed: " + MigrationContext.getIdentitiesMigrateActivityFailed()));
                                }
                                LOG.info((Object)String.format("Cleanup relationship in %s (ms)", timeToCleanupConnections));
                                LOG.info((Object)String.format("- cleanup connection failed for %s user(s)", MigrationContext.getIdentitiesCleanupConnectionFailed().size()));
                                if (!MigrationContext.getIdentitiesCleanupConnectionFailed().isEmpty()) {
                                    LOG.warn((Object)("- identities cleanup failed: " + MigrationContext.getIdentitiesCleanupConnectionFailed()));
                                }
                                LOG.info((Object)String.format("Cleanup activities in %s (ms)", timeToCleanupActivities));
                                LOG.info((Object)String.format("- cleanup activities failed for %s identity(s)", MigrationContext.getIdentitiesCleanupActivityFailed().size()));
                                if (!MigrationContext.getIdentitiesCleanupActivityFailed().isEmpty()) {
                                    LOG.warn((Object)("- identities cleanup failed: " + MigrationContext.getIdentitiesCleanupActivityFailed()));
                                }
                                LOG.info((Object)String.format("Cleanup identities in %s (ms)", timeToCleanupIdentities));
                                LOG.info((Object)String.format("- cleanup failed for %s identity(s)", MigrationContext.getIdentitiesCleanupFailed().size()));
                                if (!MigrationContext.getIdentitiesCleanupFailed().isEmpty()) {
                                    LOG.warn((Object)("- identities cleanup failed: " + MigrationContext.getIdentitiesCleanupFailed()));
                                }
                                LOG.info((Object)String.format("Cleanup spaces in %s (ms)", timeToCleanupSpaces));
                                LOG.info((Object)String.format("- cleanup failed for %s space(s)", MigrationContext.getSpaceCleanupFailed().size()));
                                if (!MigrationContext.getSpaceCleanupFailed().isEmpty()) {
                                    LOG.warn((Object)("- space cleanup failed: " + MigrationContext.getSpaceCleanupFailed()));
                                }
                            }
                            RDBMSMigrationManager.this.migrater.countDown();
                            throw throwable;
                        }
                        RDBMSMigrationManager.this.removeRunningNodeIfPresent(start);
                        if (field != null) {
                            try {
                                field.set(null, false);
                            }
                            catch (IllegalArgumentException e4) {
                                LOG.warn((Object)e4.getMessage(), (Throwable)e4);
                            }
                            catch (IllegalAccessException e5) {
                                LOG.warn((Object)e5.getMessage(), (Throwable)e5);
                            }
                        }
                        LOG.info((Object)String.format("Migration job has done, total time is %s (ms)", System.currentTimeMillis() - startTime));
                        LOG.info((Object)String.format("Migration space in %s (ms)", timeToMigrateSpaces));
                        LOG.info((Object)String.format("- Number space failed: %s", MigrationContext.getSpaceMigrateFailed().size()));
                        if (!MigrationContext.getSpaceMigrateFailed().isEmpty()) {
                            LOG.warn((Object)("- space failed: " + MigrationContext.getSpaceMigrateFailed()));
                        }
                        LOG.info((Object)String.format("Migration identities in %s (ms)", timeToMigrateIdentities));
                        LOG.info((Object)String.format("- Number identities failed: %s", MigrationContext.getIdentitiesMigrateFailed().size()));
                        if (!MigrationContext.getIdentitiesMigrateFailed().isEmpty()) {
                            LOG.warn((Object)("- identities failed: " + MigrationContext.getIdentitiesMigrateFailed()));
                        }
                        if (!MigrationContext.getIdentitiesMigrateFailed().isEmpty()) {
                            LOG.info((Object)"We could not continue migration job because the identities migration was failed");
                        } else {
                            LOG.info((Object)String.format("Migration relationships in %s (ms)", timeToMigrateConnections));
                            LOG.info((Object)String.format("- migrate failed for %s user(s)", MigrationContext.getIdentitiesMigrateConnectionFailed().size()));
                            if (!MigrationContext.getIdentitiesMigrateConnectionFailed().isEmpty()) {
                                LOG.warn((Object)("- identities failed: " + MigrationContext.getIdentitiesMigrateConnectionFailed()));
                            }
                            LOG.info((Object)String.format("Migration activities in %s (ms)", timeToMigrateActivities));
                            LOG.info((Object)String.format("- migrate failed for %s user(s)", MigrationContext.getIdentitiesMigrateActivityFailed().size()));
                            if (!MigrationContext.getIdentitiesMigrateActivityFailed().isEmpty()) {
                                LOG.warn((Object)("- identities failed: " + MigrationContext.getIdentitiesMigrateActivityFailed()));
                            }
                            LOG.info((Object)String.format("Cleanup relationship in %s (ms)", timeToCleanupConnections));
                            LOG.info((Object)String.format("- cleanup connection failed for %s user(s)", MigrationContext.getIdentitiesCleanupConnectionFailed().size()));
                            if (!MigrationContext.getIdentitiesCleanupConnectionFailed().isEmpty()) {
                                LOG.warn((Object)("- identities cleanup failed: " + MigrationContext.getIdentitiesCleanupConnectionFailed()));
                            }
                            LOG.info((Object)String.format("Cleanup activities in %s (ms)", timeToCleanupActivities));
                            LOG.info((Object)String.format("- cleanup activities failed for %s identity(s)", MigrationContext.getIdentitiesCleanupActivityFailed().size()));
                            if (!MigrationContext.getIdentitiesCleanupActivityFailed().isEmpty()) {
                                LOG.warn((Object)("- identities cleanup failed: " + MigrationContext.getIdentitiesCleanupActivityFailed()));
                            }
                            LOG.info((Object)String.format("Cleanup identities in %s (ms)", timeToCleanupIdentities));
                            LOG.info((Object)String.format("- cleanup failed for %s identity(s)", MigrationContext.getIdentitiesCleanupFailed().size()));
                            if (!MigrationContext.getIdentitiesCleanupFailed().isEmpty()) {
                                LOG.warn((Object)("- identities cleanup failed: " + MigrationContext.getIdentitiesCleanupFailed()));
                            }
                            LOG.info((Object)String.format("Cleanup spaces in %s (ms)", timeToCleanupSpaces));
                            LOG.info((Object)String.format("- cleanup failed for %s space(s)", MigrationContext.getSpaceCleanupFailed().size()));
                            if (!MigrationContext.getSpaceCleanupFailed().isEmpty()) {
                                LOG.warn((Object)("- space cleanup failed: " + MigrationContext.getSpaceCleanupFailed()));
                            }
                        }
                        RDBMSMigrationManager.this.migrater.countDown();
                    }
                }
                RDBMSMigrationManager.this.removeRunningNodeIfPresent(start);
                if (field != null) {
                    try {
                        field.set(null, false);
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        LOG.warn((Object)e.getMessage(), (Throwable)e);
                    }
                }
                LOG.info((Object)String.format("Migration job has done, total time is %s (ms)", System.currentTimeMillis() - startTime));
                LOG.info((Object)String.format("Migration space in %s (ms)", timeToMigrateSpaces));
                LOG.info((Object)String.format("- Number space failed: %s", MigrationContext.getSpaceMigrateFailed().size()));
                if (!MigrationContext.getSpaceMigrateFailed().isEmpty()) {
                    LOG.warn((Object)("- space failed: " + MigrationContext.getSpaceMigrateFailed()));
                }
                LOG.info((Object)String.format("Migration identities in %s (ms)", timeToMigrateIdentities));
                LOG.info((Object)String.format("- Number identities failed: %s", MigrationContext.getIdentitiesMigrateFailed().size()));
                if (!MigrationContext.getIdentitiesMigrateFailed().isEmpty()) {
                    LOG.warn((Object)("- identities failed: " + MigrationContext.getIdentitiesMigrateFailed()));
                }
                if (!MigrationContext.getIdentitiesMigrateFailed().isEmpty()) {
                    LOG.info((Object)"We could not continue migration job because the identities migration was failed");
                } else {
                    LOG.info((Object)String.format("Migration relationships in %s (ms)", timeToMigrateConnections));
                    LOG.info((Object)String.format("- migrate failed for %s user(s)", MigrationContext.getIdentitiesMigrateConnectionFailed().size()));
                    if (!MigrationContext.getIdentitiesMigrateConnectionFailed().isEmpty()) {
                        LOG.warn((Object)("- identities failed: " + MigrationContext.getIdentitiesMigrateConnectionFailed()));
                    }
                    LOG.info((Object)String.format("Migration activities in %s (ms)", timeToMigrateActivities));
                    LOG.info((Object)String.format("- migrate failed for %s user(s)", MigrationContext.getIdentitiesMigrateActivityFailed().size()));
                    if (!MigrationContext.getIdentitiesMigrateActivityFailed().isEmpty()) {
                        LOG.warn((Object)("- identities failed: " + MigrationContext.getIdentitiesMigrateActivityFailed()));
                    }
                    LOG.info((Object)String.format("Cleanup relationship in %s (ms)", timeToCleanupConnections));
                    LOG.info((Object)String.format("- cleanup connection failed for %s user(s)", MigrationContext.getIdentitiesCleanupConnectionFailed().size()));
                    if (!MigrationContext.getIdentitiesCleanupConnectionFailed().isEmpty()) {
                        LOG.warn((Object)("- identities cleanup failed: " + MigrationContext.getIdentitiesCleanupConnectionFailed()));
                    }
                    LOG.info((Object)String.format("Cleanup activities in %s (ms)", timeToCleanupActivities));
                    LOG.info((Object)String.format("- cleanup activities failed for %s identity(s)", MigrationContext.getIdentitiesCleanupActivityFailed().size()));
                    if (!MigrationContext.getIdentitiesCleanupActivityFailed().isEmpty()) {
                        LOG.warn((Object)("- identities cleanup failed: " + MigrationContext.getIdentitiesCleanupActivityFailed()));
                    }
                    LOG.info((Object)String.format("Cleanup identities in %s (ms)", timeToCleanupIdentities));
                    LOG.info((Object)String.format("- cleanup failed for %s identity(s)", MigrationContext.getIdentitiesCleanupFailed().size()));
                    if (!MigrationContext.getIdentitiesCleanupFailed().isEmpty()) {
                        LOG.warn((Object)("- identities cleanup failed: " + MigrationContext.getIdentitiesCleanupFailed()));
                    }
                    LOG.info((Object)String.format("Cleanup spaces in %s (ms)", timeToCleanupSpaces));
                    LOG.info((Object)String.format("- cleanup failed for %s space(s)", MigrationContext.getSpaceCleanupFailed().size()));
                    if (!MigrationContext.getSpaceCleanupFailed().isEmpty()) {
                        LOG.warn((Object)("- space cleanup failed: " + MigrationContext.getSpaceCleanupFailed()));
                    }
                }
                RDBMSMigrationManager.this.migrater.countDown();
            }
        };
        this.migrationThread = new Thread(migrateTask);
        this.migrationThread.setPriority(5);
        this.migrationThread.setName("SOC-MIGRATION-RDBMS");
        this.migrationThread.start();
    }

    private void initMigrationSetting() {
        this.settingService = (SettingService)CommonsUtils.getService(SettingService.class);
        MigrationContext.setDone(this.getOrCreateSettingValue("SOC_RDBMS_MIGRATION_DONE"));
        MigrationContext.setConnectionDone(this.getOrCreateSettingValue("SOC_RDBMS_CONNECTION_MIGRATION_DONE"));
        MigrationContext.setConnectionCleanupDone(this.getOrCreateSettingValue("SOC_RDBMS_CONNECTION_CLEANUP_DONE"));
        MigrationContext.setActivityDone(this.getOrCreateSettingValue("SOC_RDBMS_ACTIVITY_MIGRATION_DONE"));
        MigrationContext.setActivityCleanupDone(this.getOrCreateSettingValue("SOC_RDBMS_ACTIVITY_CLEANUP_DONE"));
        MigrationContext.setSpaceDone(this.getOrCreateSettingValue("SOC_RDBMS_SPACE_MIGRATION_DONE"));
        MigrationContext.setSpaceCleanupDone(this.getOrCreateSettingValue("SOC_RDBMS_SPACE_CLEANUP_DONE"));
        MigrationContext.setIdentityDone(this.getOrCreateSettingValue("SOC_RDBMS_IDENTITY_MIGRATION_DONE"));
        MigrationContext.setIdentityCleanupDone(this.getOrCreateSettingValue("SOC_RDBMS_IDENTITY_CLEANUP_DONE"));
        MigrationContext.setForceCleanup(this.forceRemoveJCR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getOrCreateSettingValue(String key) {
        try {
            SettingValue migrationValue = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(MIGRATION_SETTING_GLOBAL_KEY), key);
            if (migrationValue != null) {
                boolean bl = Boolean.parseBoolean(migrationValue.getValue().toString());
                return bl;
            }
            this.updateSettingValue(key, Boolean.FALSE);
            boolean bl = false;
            return bl;
        }
        finally {
            Scope.GLOBAL.id(null);
        }
    }

    private void updateSettingValue(String key, Boolean status) {
        try {
            RequestLifeCycle.begin((ExoContainer)ExoContainerContext.getCurrentContainer());
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(MIGRATION_SETTING_GLOBAL_KEY), key, SettingValue.create((Boolean)status));
        }
        finally {
            Scope.GLOBAL.id(null);
            RequestLifeCycle.end();
        }
    }

    private boolean checkCanStartMigration() {
        if (!this.clusterMode) {
            return true;
        }
        try {
            SettingValue migrationValue = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(MIGRATION_SETTING_GLOBAL_KEY), MIGRATION_RUNNING_NODE_KEY);
            if (migrationValue == null || migrationValue.getValue() == null) {
                this.settingService.set(Context.GLOBAL, Scope.GLOBAL.id(MIGRATION_SETTING_GLOBAL_KEY), MIGRATION_RUNNING_NODE_KEY, SettingValue.create((String)this.nodeName));
                migrationValue = this.settingService.get(Context.GLOBAL, Scope.GLOBAL.id(MIGRATION_SETTING_GLOBAL_KEY), MIGRATION_RUNNING_NODE_KEY);
            }
            if (migrationValue != null && migrationValue.getValue() != null && ((String)migrationValue.getValue()).equals(this.nodeName)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Scope.GLOBAL.id(null);
        }
    }

    private void updateMigrationSettings(boolean remove) {
        this.updateSettingValue("SOC_RDBMS_CONNECTION_MIGRATION_DONE", Boolean.TRUE);
        this.updateSettingValue("SOC_RDBMS_ACTIVITY_MIGRATION_DONE", Boolean.TRUE);
        this.updateSettingValue("SOC_RDBMS_SPACE_MIGRATION_DONE", Boolean.TRUE);
        this.updateSettingValue("SOC_RDBMS_IDENTITY_MIGRATION_DONE", Boolean.TRUE);
        this.updateSettingValue("SOC_RDBMS_CONNECTION_CLEANUP_DONE", Boolean.TRUE);
        this.updateSettingValue("SOC_RDBMS_ACTIVITY_CLEANUP_DONE", Boolean.TRUE);
        this.updateSettingValue("SOC_RDBMS_SPACE_CLEANUP_DONE", Boolean.TRUE);
        this.updateSettingValue("SOC_RDBMS_IDENTITY_CLEANUP_DONE", Boolean.TRUE);
        this.updateSettingValue("SOC_RDBMS_MIGRATION_DONE", Boolean.TRUE);
        MigrationContext.setDone(true);
        this.removeRunningNodeIfPresent(remove);
    }

    private void removeRunningNodeIfPresent(boolean remove) {
        if (!this.clusterMode || !remove) {
            return;
        }
        try {
            this.settingService.remove(Context.GLOBAL, Scope.GLOBAL.id(MIGRATION_SETTING_GLOBAL_KEY), MIGRATION_RUNNING_NODE_KEY);
        }
        finally {
            Scope.GLOBAL.id(null);
        }
    }

    private ActivityMigrationService getActivityMigrationService() {
        if (this.activityMigration == null) {
            this.activityMigration = (ActivityMigrationService)((Object)CommonsUtils.getService(ActivityMigrationService.class));
        }
        return this.activityMigration;
    }

    public void stop() {
        this.relationshipMigration.stop();
        this.getActivityMigrationService().stop();
        try {
            this.migrationThread.join();
        }
        catch (InterruptedException e) {
            LOG.error((Object)e);
        }
    }

    public CountDownLatch getMigrater() {
        return this.migrater;
    }
}

