/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.gadget.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CharResponseWrapper
extends HttpServletResponseWrapper {
    private ByteArrayPrintWriter output = new ByteArrayPrintWriter();
    private boolean usingWriter = false;

    public CharResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public byte[] getByteArray() {
        return this.output.toByteArray();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.usingWriter) {
            super.getOutputStream();
        }
        this.usingWriter = true;
        return this.output.getStream();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.usingWriter) {
            super.getWriter();
        }
        this.usingWriter = true;
        return this.output.getWriter();
    }

    public String toString() {
        return this.output.toString();
    }

    public static class ByteArrayPrintWriter {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private PrintWriter pw = new PrintWriter(this.baos);
        private ServletOutputStream sos = new ByteArrayServletStream(this.baos);

        public PrintWriter getWriter() {
            return this.pw;
        }

        public ServletOutputStream getStream() {
            return this.sos;
        }

        byte[] toByteArray() {
            return this.baos.toByteArray();
        }
    }

    public static class ByteArrayServletStream
    extends ServletOutputStream {
        ByteArrayOutputStream baos;

        public ByteArrayServletStream(ByteArrayOutputStream baos) {
            this.baos = baos;
        }

        public void write(int param) throws IOException {
            this.baos.write(param);
        }
    }
}

